/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.fat.BootSector;
import de.waldheinz.fs.fat.FatType;
import java.io.IOException;

final class Fat32BootSector
extends BootSector {
    public static final int ROOT_DIR_FIRST_CLUSTER_OFFSET = 44;
    public static final int SECTORS_PER_FAT_OFFSET = 36;
    public static final int FILE_SYSTEM_TYPE_OFFSET = 82;
    public static final int VERSION_OFFSET = 42;
    public static final int VERSION = 0;
    public static final int FS_INFO_SECTOR_OFFSET = 48;
    public static final int BOOT_SECTOR_COPY_OFFSET = 50;
    public static final int EXTENDED_BOOT_SIGNATURE_OFFSET = 66;

    public Fat32BootSector(BlockDevice device) throws IOException {
        super(device);
    }

    @Override
    public void init() throws IOException {
        super.init();
        this.set16(42, 0);
        this.setBootSectorCopySector(6);
    }

    public long getRootDirFirstCluster() {
        return this.get32(44);
    }

    public void setRootDirFirstCluster(long value) {
        if (this.getRootDirFirstCluster() == value) {
            return;
        }
        this.set32(44, value);
    }

    public void setBootSectorCopySector(int sectNr) {
        if (this.getBootSectorCopySector() == sectNr) {
            return;
        }
        if (sectNr < 0) {
            throw new IllegalArgumentException("boot sector copy sector must be >= 0");
        }
        this.set16(50, sectNr);
    }

    public int getBootSectorCopySector() {
        return this.get16(50);
    }

    public void setVolumeLabel(String label) {
        for (int i = 0; i < 11; ++i) {
            int c = label == null ? 0 : (label.length() > i ? (int)label.charAt(i) : 32);
            this.set8(71 + i, c);
        }
    }

    public int getFsInfoSectorNr() {
        return this.get16(48);
    }

    public void setFsInfoSectorNr(int offset) {
        if (this.getFsInfoSectorNr() == offset) {
            return;
        }
        this.set16(48, offset);
    }

    @Override
    public void setSectorsPerFat(long v) {
        if (this.getSectorsPerFat() == v) {
            return;
        }
        this.set32(36, v);
    }

    @Override
    public long getSectorsPerFat() {
        return this.get32(36);
    }

    @Override
    public FatType getFatType() {
        return FatType.FAT32;
    }

    @Override
    public void setSectorCount(long count) {
        super.setNrTotalSectors(count);
    }

    @Override
    public long getSectorCount() {
        return super.getNrTotalSectors();
    }

    @Override
    public int getRootDirEntryCount() {
        return 0;
    }

    public void setFileSystemId(int id) {
        super.set32(67, id);
    }

    public int getFileSystemId() {
        return (int)super.get32(67);
    }

    public void writeCopy(BlockDevice device) throws IOException {
        if (this.getBootSectorCopySector() > 0) {
            long offset = (long)this.getBootSectorCopySector() * 512L;
            this.buffer.rewind();
            this.buffer.limit(this.buffer.capacity());
            device.write(offset, this.buffer);
        }
    }

    @Override
    public int getFileSystemTypeLabelOffset() {
        return 82;
    }

    @Override
    public int getExtendedBootSignatureOffset() {
        return 66;
    }
}

