/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command;

import java.io.PrintWriter;
import org.apache.commons.cli.HelpFormatter;
import uk.gov.nationalarchives.droid.command.action.DroidCommand;
import uk.gov.nationalarchives.droid.command.filter.DqlCriterionMapper;
import uk.gov.nationalarchives.droid.command.i18n.I18N;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionFieldEnum;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionOperator;

public class FilterFieldCommand
implements DroidCommand {
    private static final String NAME_DESCRIPTION = "%s\t%s";
    private static final int LINE_INDENT = 4;
    private static final int LINE_WIDTH = 80;
    private static final String BASE_PROPERTY = "dql.help.";
    private PrintWriter printWriter;
    private HelpFormatter helpFormatter = new HelpFormatter();

    public FilterFieldCommand(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    @Override
    public void execute() {
        String text;
        String description;
        this.helpFormatter.printWrapped(this.printWriter, 80, 4, "Filter fields:");
        for (String fieldName : DqlCriterionMapper.allDqlFields()) {
            CriterionFieldEnum field = DqlCriterionMapper.forField(fieldName);
            description = I18N.getResource(BASE_PROPERTY + field.name());
            text = String.format(NAME_DESCRIPTION, fieldName, description);
            this.helpFormatter.printWrapped(this.printWriter, 80, 4, text);
        }
        this.helpFormatter.printWrapped(this.printWriter, 80, 4, "\nFilter operators:");
        for (String operatorName : DqlCriterionMapper.allDqlOperators()) {
            CriterionOperator operator = DqlCriterionMapper.forOperator(operatorName);
            description = I18N.getResource(BASE_PROPERTY + operator.name());
            text = String.format(NAME_DESCRIPTION, operatorName, description);
            this.helpFormatter.printWrapped(this.printWriter, 80, 4, text);
        }
        this.printWriter.flush();
    }
}

