/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.action;

import java.io.PrintWriter;
import java.util.Map;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.action.DroidCommand;
import uk.gov.nationalarchives.droid.command.i18n.I18N;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileException;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureManager;

public class DisplayDefaultSignatureFileVersionCommand
implements DroidCommand {
    private PrintWriter printWriter;
    private SignatureManager signatureManager;

    @Override
    public void execute() throws CommandExecutionException {
        try {
            Map sigFileInfos = this.signatureManager.getDefaultSignatures();
            for (SignatureFileInfo info : sigFileInfos.values()) {
                this.printWriter.println(I18N.getResource("signature.display", info.getType(), info.getVersion(), info.getFile().getFileName().toString()));
            }
        }
        catch (SignatureFileException e) {
            throw new CommandExecutionException(e);
        }
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    public void setSignatureManager(SignatureManager signatureManager) {
        this.signatureManager = signatureManager;
    }
}

