/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.archive;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import uk.gov.nationalarchives.droid.command.ResultPrinter;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.archive.ArchiveConfiguration;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;

public abstract class ArchiveContentIdentifier {
    protected String slash;
    protected String slash1;
    protected BinarySignatureIdentifier binarySignatureIdentifier;
    protected ContainerSignatureDefinitions containerSignatureDefinitions;
    protected Path tmpDir;
    protected String path;
    private ArchiveConfiguration archiveConfiguration;
    protected static final String START_PARENTHESIS = " (";
    protected static final String END_PARENTHESIS = ")";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveContentIdentifier(BinarySignatureIdentifier binarySignatureIdentifier, ContainerSignatureDefinitions containerSignatureDefinitions, String path, String slash, String slash1, ArchiveConfiguration archiveConfiguration) {
        ArchiveContentIdentifier archiveContentIdentifier = this;
        synchronized (archiveContentIdentifier) {
            this.setBinarySignatureIdentifier(binarySignatureIdentifier);
            this.setContainerSignatureDefinitions(containerSignatureDefinitions);
            this.setPath(path);
            this.setSlash(slash);
            this.setSlash1(slash1);
            this.setArchiveConfiguration(archiveConfiguration);
            if (this.getTmpDir() == null) {
                this.setTmpDir(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]));
            }
        }
    }

    protected String getSlash() {
        return this.slash;
    }

    protected void setSlash(String newSlash) {
        this.slash = newSlash;
    }

    protected String getSlash1() {
        return this.slash1;
    }

    protected void setSlash1(String newSlash1) {
        this.slash1 = newSlash1;
    }

    protected BinarySignatureIdentifier getBinarySignatureIdentifier() {
        return this.binarySignatureIdentifier;
    }

    protected void setBinarySignatureIdentifier(BinarySignatureIdentifier bis) {
        this.binarySignatureIdentifier = bis;
    }

    protected ContainerSignatureDefinitions getContainerSignatureDefinitions() {
        return this.containerSignatureDefinitions;
    }

    protected void setContainerSignatureDefinitions(ContainerSignatureDefinitions csd) {
        this.containerSignatureDefinitions = csd;
    }

    protected Path getTmpDir() {
        return this.tmpDir;
    }

    protected void setTmpDir(Path tmpDir) {
        this.tmpDir = tmpDir;
    }

    protected String getPath() {
        return this.path;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    protected String makeContainerURI(String prefix, String filename) {
        return prefix + ":" + this.getSlash1() + this.getPath() + filename + "!" + this.getSlash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expandContainer(IdentificationRequest request, InputStream in, String newPath) throws CommandExecutionException {
        try {
            request.open((Object)in);
            IdentificationResultCollection results = this.getBinarySignatureIdentifier().matchBinarySignatures(request);
            ResultPrinter resultPrinter = new ResultPrinter(this.getBinarySignatureIdentifier(), this.getContainerSignatureDefinitions(), newPath, this.getSlash(), this.getSlash1(), this.getArchiveConfiguration());
            resultPrinter.print(results, request);
            request.close();
        }
        catch (IOException ioe) {
            System.err.println(ioe + " " + newPath);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException ioe) {
                System.err.println("Failed to close temp file for Container request:" + ioe);
            }
        }
    }

    public ArchiveConfiguration getArchiveConfiguration() {
        return this.archiveConfiguration;
    }

    public void setArchiveConfiguration(ArchiveConfiguration archiveConfiguration) {
        this.archiveConfiguration = archiveConfiguration;
    }
}

