/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.filter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import uk.gov.nationalarchives.droid.command.filter.DqlCriterionFactory;
import uk.gov.nationalarchives.droid.command.filter.DqlCriterionMapper;
import uk.gov.nationalarchives.droid.command.filter.DqlFilterParser;
import uk.gov.nationalarchives.droid.command.filter.DqlParseException;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionOperator;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterCriterion;

public class SimpleDqlFilterParser
implements DqlFilterParser {
    private static final String INVALID_ARGUMENT_COUNT = "The filter condition \"%s\" is invalid, since it has only %d arguments - at least 3 are required (are you missing an operator, or a space?)";
    private static final String INVALID_ARGUMENT_COUNT_FOR_STRING_OPERATOR = "The filter condition \"%s\" is invalid, since it has  %d arguments.  String based filter conditions must supply one string value enclosed in single quotes for the final argument";
    private static final String INVALID_USE_OF_NOT = "The filter condition \"%s\" is invalid. The \"not\" operator can only be used with string operators \"starts\", \"ends\" and \"contains\"";
    private static final String MISSING_SINGLE_QUOTES = "The filter condition \"%s\" is invalid. Queries with \"starts\", \"ends\" and \"contains\" must be followed by a  value enclosed in single quotes after the operator.";
    private static final String INVALID_COMPARISON_FILTER = "The filter condition \"%s\" is invalid.  Filters using a comparison operator must supply a single integer numeric operand, or (for the \"=\" operator only) a string surrounded by single quotes. Dates must use the format yyyy-mm-dd, e.g. 2010-01-23 for 23rd Jan 2010";
    private static final String SINGLE_QUOTE = "'";
    private static final int MIMIMUM_FILTER_COMPONENTS = 3;
    private static final int VALUES_START_INDEX_WITH_NOT_OPERATOR = 3;
    private static final int VALUES_START_INDEX_SANS_NOT_OPERATOR = 2;

    @Override
    public FilterCriterion parse(String dql) {
        try {
            boolean operatorIsTwoPart;
            Pattern p = Pattern.compile("(?<!(\\\\'|\"|'[a-zA-Z0-9\"]{1,1000})) (?!(\\\\|\").*)");
            String[] filterComponents = dql.split(p.pattern());
            String dqlOperator = null;
            String value = null;
            int valuesStartIndex = 0;
            FilterCriterion criterion = null;
            if (filterComponents.length < 3) {
                throw new DqlParseException(String.format(INVALID_ARGUMENT_COUNT, dql, filterComponents.length));
            }
            String dqlField = filterComponents[0];
            boolean bl = operatorIsTwoPart = filterComponents[1].toLowerCase().equals("not");
            if (operatorIsTwoPart) {
                String[] operators = Arrays.copyOfRange(filterComponents, 1, 3);
                dqlOperator = operators[0] + " " + operators[1];
                valuesStartIndex = 3;
            } else {
                dqlOperator = filterComponents[1];
                valuesStartIndex = 2;
            }
            if (SimpleDqlFilterParser.isStringOperator(dqlOperator)) {
                if (operatorIsTwoPart && filterComponents.length != 4 || !operatorIsTwoPart && filterComponents.length != 3) {
                    throw new DqlParseException(String.format(INVALID_ARGUMENT_COUNT_FOR_STRING_OPERATOR, dql, filterComponents.length));
                }
                value = filterComponents[valuesStartIndex];
                if (!value.startsWith(SINGLE_QUOTE) || !value.endsWith(SINGLE_QUOTE)) {
                    throw new DqlParseException(String.format(MISSING_SINGLE_QUOTES, dql));
                }
                criterion = DqlCriterionFactory.newCriterion(dqlField, dqlOperator, SimpleDqlFilterParser.fromDqlString(value));
            } else {
                if (operatorIsTwoPart) {
                    throw new DqlParseException(String.format(INVALID_USE_OF_NOT, dql));
                }
                if (SimpleDqlFilterParser.isComparisonOperator(dqlOperator)) {
                    if (filterComponents.length != 3) {
                        throw new DqlParseException(String.format(INVALID_COMPARISON_FILTER, dql));
                    }
                    value = filterComponents[valuesStartIndex];
                    if (!(SimpleDqlFilterParser.isLongInteger(value) || SimpleDqlFilterParser.isBoolean(value) || SimpleDqlFilterParser.isDateValue(value) || SimpleDqlFilterParser.isQuotedString(value) && SimpleDqlFilterParser.isEqualsOperator(dqlOperator))) {
                        throw new DqlParseException(String.format(INVALID_COMPARISON_FILTER, dql));
                    }
                    criterion = DqlCriterionFactory.newCriterion(dqlField, dqlOperator, SimpleDqlFilterParser.fromDqlString(value));
                } else {
                    ArrayList<String> dqlValues = new ArrayList<String>();
                    for (int i = valuesStartIndex; i < filterComponents.length; ++i) {
                        dqlValues.add(SimpleDqlFilterParser.fromDqlString(filterComponents[i]));
                    }
                    criterion = DqlCriterionFactory.newCriterion(dqlField, dqlOperator, dqlValues);
                }
            }
            return criterion;
        }
        catch (IllegalArgumentException e) {
            throw new DqlParseException(e);
        }
        catch (DqlParseException e) {
            throw e;
        }
    }

    private static String fromDqlString(String dqlString) {
        return StringUtils.strip((String)dqlString, (String)SINGLE_QUOTE).replace("\\'", SINGLE_QUOTE);
    }

    private static boolean isStringOperator(String operator) {
        CriterionOperator criterionOperator = DqlCriterionMapper.forOperator(operator);
        return criterionOperator == CriterionOperator.STARTS_WITH || criterionOperator == CriterionOperator.NOT_STARTS_WITH || criterionOperator == CriterionOperator.ENDS_WITH || criterionOperator == CriterionOperator.NOT_ENDS_WITH || criterionOperator == CriterionOperator.CONTAINS || criterionOperator == CriterionOperator.NOT_CONTAINS;
    }

    private static boolean isComparisonOperator(String operator) {
        CriterionOperator criterionOperator = DqlCriterionMapper.forOperator(operator);
        return criterionOperator == CriterionOperator.EQ || criterionOperator == CriterionOperator.GT || criterionOperator == CriterionOperator.GTE || criterionOperator == CriterionOperator.LT || criterionOperator == CriterionOperator.LTE || criterionOperator == CriterionOperator.NE;
    }

    private static boolean isEqualsOperator(String operator) {
        CriterionOperator criterionOperator = DqlCriterionMapper.forOperator(operator);
        return criterionOperator == CriterionOperator.EQ;
    }

    private static boolean isQuotedString(String value) {
        return value.startsWith(SINGLE_QUOTE) && value.endsWith(SINGLE_QUOTE);
    }

    private static boolean isLongInteger(String str) {
        try {
            Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private static boolean isDateValue(String value) {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sdf.parse(value);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date != null;
    }

    private static boolean isBoolean(String value) {
        try {
            return SimpleDqlFilterParser.fromDqlString(value).equalsIgnoreCase("true") || SimpleDqlFilterParser.fromDqlString(value).equalsIgnoreCase("false");
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

