/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.report.interfaces;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class ReportData {
    @XmlElement(name="Count")
    private long count;
    @XmlElement(name="Sum")
    private Long sum;
    @XmlElement(name="Min")
    private Long min;
    @XmlElement(name="Max")
    private Long max;
    @XmlElement(name="Average")
    private Long roundedAverage;
    @XmlTransient
    private Double average;

    public void setAverage(Double average) {
        this.average = average;
        this.updateRoundedAverage();
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public void setMax(Long max) {
        this.max = max;
    }

    public void setMin(Long min) {
        this.min = min;
    }

    public void setSum(Long sum) {
        this.sum = sum;
    }

    private void updateMinAndMax(ReportData reportData) {
        if (reportData.min != null && (this.min == null || reportData.min < this.min)) {
            this.min = reportData.min;
        }
        if (reportData.max != null && (this.max == null || reportData.max > this.max)) {
            this.max = reportData.max;
        }
    }

    private void updateRoundedAverage() {
        this.roundedAverage = this.average == null ? null : Long.valueOf(Math.round(this.average));
    }

    public void addData(ReportData reportData) {
        double thisAverage;
        this.updateMinAndMax(reportData);
        double d = thisAverage = this.average == null ? 0.0 : this.average;
        if (reportData.average != null) {
            double temp = thisAverage * (double)this.count + reportData.average * (double)reportData.count;
            this.count += reportData.count;
            this.average = temp / (double)this.count;
            this.updateRoundedAverage();
        } else {
            this.count += reportData.count;
        }
        if (reportData.sum != null) {
            this.sum = this.sum == null ? reportData.sum : Long.valueOf(this.sum + reportData.sum);
        }
    }
}

