/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.io.IOException;
import java.io.InputStream;
import org.jwat.arc.ArcHeader;
import org.jwat.arc.ArcReader;
import org.jwat.arc.ArcRecordBase;
import org.jwat.arc.ArcWriter;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.common.Diagnosis;
import org.jwat.common.DiagnosisType;
import org.jwat.common.Diagnostics;
import org.jwat.common.HttpHeader;
import org.jwat.common.Payload;
import org.jwat.common.PayloadOnClosedHandler;
import org.jwat.common.PayloadWithHeaderAbstract;

public class ArcRecord
extends ArcRecordBase {
    public static final int TOSTRING_BUFFER_SIZE = 256;

    protected ArcRecord() {
    }

    public static ArcRecord createRecord(ArcWriter writer) {
        ArcRecord ar = new ArcRecord();
        ar.trailingNewLines = 1;
        ar.diagnostics = new Diagnostics();
        ar.header = ArcHeader.initHeader(writer, (Diagnostics<Diagnosis>)ar.diagnostics);
        writer.fieldParsers.diagnostics = ar.diagnostics;
        return ar;
    }

    public static ArcRecord parseArcRecord(ArcReader reader, Diagnostics<Diagnosis> diagnostics, ArcHeader header, ByteCountingPushBackInputStream in) throws IOException {
        ArcRecord ar = new ArcRecord();
        ar.recordType = 2;
        ar.reader = reader;
        ar.diagnostics = diagnostics;
        ar.header = header;
        ar.in = in;
        ar.processPayload(in, reader);
        ar.consumed = in.getConsumed() - ar.header.startOffset;
        return ar;
    }

    @Override
    protected void processPayload(ByteCountingPushBackInputStream in, ArcReader reader) throws IOException {
        this.payload = null;
        if (this.header.archiveLength != null && this.header.archiveLength > 0L) {
            String digestAlgorithm = null;
            if (reader.bBlockDigest) {
                digestAlgorithm = reader.blockDigestAlgorithm;
            }
            this.payload = Payload.processPayload((InputStream)in, (long)this.header.archiveLength, (int)reader.payloadHeaderMaxSize, (String)digestAlgorithm);
            this.payload.setOnClosedHandler((PayloadOnClosedHandler)this);
            if (HttpHeader.isSupported((String)this.header.urlScheme)) {
                digestAlgorithm = null;
                if (reader.bPayloadDigest) {
                    digestAlgorithm = reader.payloadDigestAlgorithm;
                }
                this.httpHeader = HttpHeader.processPayload((int)1, (ByteCountingPushBackInputStream)this.payload.getInputStream(), (long)this.header.archiveLength, (String)digestAlgorithm);
                if (this.httpHeader != null) {
                    if (this.httpHeader.isValid()) {
                        this.payload.setPayloadHeaderWrapped((PayloadWithHeaderAbstract)this.httpHeader);
                    } else {
                        this.diagnostics.addError((Object)new Diagnosis(DiagnosisType.ERROR, "http header", new String[]{"Unable to parse http header!"}));
                    }
                }
            }
        } else if (HttpHeader.isSupported((String)this.header.urlScheme)) {
            this.diagnostics.addError((Object)new Diagnosis(DiagnosisType.ERROR_EXPECTED, "ARC file", new String[]{"Expected payload not found in the record block"}));
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("\nArcRecord [");
        builder.append(super.toString());
        builder.append(']');
        if (this.httpHeader != null) {
            builder.append(this.httpHeader.toString());
        }
        return builder.toString();
    }
}

