/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar;

import com.github.junrar.Archive;
import com.github.junrar.ExtractDestination;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import com.github.junrar.vfs2.provider.rar.FileSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalFolderExtractor
implements ExtractDestination {
    private File folderDestination;
    private FileSystem fileSystem;
    private static final Log logger = LogFactory.getLog(LocalFolderExtractor.class);

    public LocalFolderExtractor(File destination, FileSystem fileSystem) {
        this.folderDestination = destination;
        this.fileSystem = fileSystem;
    }

    @Override
    public File createDirectory(FileHeader fh) {
        String fileName = null;
        if (fh.isDirectory()) {
            fileName = fh.isUnicode() ? fh.getFileNameW() : fh.getFileNameString();
        }
        if (fileName == null) {
            return null;
        }
        File f = new File(this.folderDestination, fileName);
        try {
            String fileCanonPath = f.getCanonicalPath();
            if (!fileCanonPath.startsWith(this.folderDestination.getCanonicalPath())) {
                String errorMessage = "Rar contains invalid path: '" + fileCanonPath + "'";
                throw new IllegalStateException(errorMessage);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File extract(Archive arch, FileHeader fileHeader) throws RarException, IOException {
        File f = this.createFile(fileHeader, this.folderDestination);
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(f);
            arch.extractFile(fileHeader, stream);
        }
        finally {
            if (stream != null) {
                ((OutputStream)stream).close();
            }
        }
        return f;
    }

    private File createFile(FileHeader fh, File destination) throws IOException {
        String name = fh.isFileHeader() && fh.isUnicode() ? fh.getFileNameW() : fh.getFileNameString();
        File f = new File(destination, name);
        String dirCanonPath = f.getCanonicalPath();
        if (!dirCanonPath.startsWith(destination.getCanonicalPath())) {
            String errorMessage = "Rar contains file with invalid path: '" + dirCanonPath + "'";
            throw new IllegalStateException(errorMessage);
        }
        if (!f.exists()) {
            try {
                f = this.makeFile(destination, name);
            }
            catch (IOException e) {
                logger.error("error creating the new file: " + f.getName(), e);
            }
        }
        return f;
    }

    private File makeFile(File destination, String name) throws IOException {
        String[] dirs = name.split("\\\\");
        if (dirs == null) {
            return null;
        }
        String path = "";
        int size = dirs.length;
        if (size == 1) {
            return new File(destination, name);
        }
        if (size > 1) {
            for (int i = 0; i < dirs.length - 1; ++i) {
                path = path + File.separator + dirs[i];
                File dir = new File(destination, path);
                this.fileSystem.mkdir(dir);
            }
            path = path + File.separator + dirs[dirs.length - 1];
            File f = new File(destination, path);
            this.fileSystem.createNewFile(f);
            return f;
        }
        return null;
    }
}

