/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.rarfile;

import com.github.junrar.io.Raw;
import com.github.junrar.rarfile.BaseBlock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockHeader
extends BaseBlock {
    public static final short blockHeaderSize = 4;
    private static final Log logger = LogFactory.getLog(BlockHeader.class);
    private long dataSize;
    private long packSize;

    public BlockHeader() {
    }

    public BlockHeader(BlockHeader bh) {
        super(bh);
        this.dataSize = this.packSize = bh.getDataSize();
        this.positionInFile = bh.getPositionInFile();
    }

    public BlockHeader(BaseBlock bb, byte[] blockHeader) {
        super(bb);
        this.dataSize = this.packSize = Raw.readIntLittleEndianAsLong(blockHeader, 0);
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getPackSize() {
        return this.packSize;
    }

    @Override
    public void print() {
        super.print();
        String s = "DataSize: " + this.getDataSize() + " packSize: " + this.getPackSize();
        logger.info(s);
    }
}

