/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.byteseek.compiler.CompileException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.gov.nationalarchives.droid.container.BinarySignatureXMLParser;
import uk.gov.nationalarchives.droid.container.ContainerFile;
import uk.gov.nationalarchives.droid.container.ContainerFileIdentificationRequest;
import uk.gov.nationalarchives.droid.container.ContainerFileIdentificationRequestFactory;
import uk.gov.nationalarchives.droid.container.ContainerSignature;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatch;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatchCollection;
import uk.gov.nationalarchives.droid.container.ContainerSignatureSaxParser;
import uk.gov.nationalarchives.droid.container.IdentifierEngine;
import uk.gov.nationalarchives.droid.container.ole2.Ole2IdentifierEngine;
import uk.gov.nationalarchives.droid.container.zip.ZipIdentifierEngine;
import uk.gov.nationalarchives.droid.core.IdentificationRequestByteReaderAdapter;
import uk.gov.nationalarchives.droid.core.SignatureFileParser;
import uk.gov.nationalarchives.droid.core.SignatureParseException;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.FileFormat;
import uk.gov.nationalarchives.droid.core.signature.compiler.ByteSequenceAnchor;
import uk.gov.nationalarchives.droid.core.signature.compiler.ByteSequenceCompiler;
import uk.gov.nationalarchives.droid.core.signature.compiler.ByteSequenceSerializer;
import uk.gov.nationalarchives.droid.core.signature.compiler.SignatureType;
import uk.gov.nationalarchives.droid.core.signature.droid6.ByteSequence;
import uk.gov.nationalarchives.droid.core.signature.droid6.FFSignatureFile;
import uk.gov.nationalarchives.droid.core.signature.droid6.InternalSignature;
import uk.gov.nationalarchives.droid.core.signature.droid6.InternalSignatureCollection;
import uk.gov.nationalarchives.droid.core.signature.xml.XmlUtils;

public final class SigUtils {
    private static final BinarySignatureXMLParser<ByteSequence> SEQ_PARSER = new BinarySignatureXMLParser();
    private static final BinarySignatureXMLParser<InternalSignature> SIG_PARSER = new BinarySignatureXMLParser();
    private static final String ZIP_SIG_XML = "<InternalSignature ID=\"200\" Specificity=\"Specific\"><ByteSequence Reference=\"BOFoffset\" Sequence=\"{0-4}'PK'0304\"/><ByteSequence Endianness=\"Little-endian\" Reference=\"EOFoffset\" Sequence=\"'PK'01{43-65531}'PK'0506{18-65531}\"/></InternalSignature>";
    private static final String OLE2_SIG_XML = "<InternalSignature ID=\"170\" Specificity=\"Specific\"><ByteSequence Reference=\"BOFoffset\" Sequence=\"D0CF11E0A1B11AE1{20}FEFF\"/></InternalSignature>";
    private static final char NEW_LINE_CHAR = '\n';
    private static final char TAB_CHAR = '\t';
    private static final String TAB_ONE = "\t1";
    private static final String TAB_ZERO = "\t0";
    private static final InternalSignatureCollection CONTAINER_SIGNATURES;
    private static final String IO_EXCEPTION_PROCESSING = "IO exception processing: ";
    private static final int ZIP_SIG_ID = 200;
    private static final int OLE2_SIG_ID = 170;
    private static final IdentifierEngine ZIP_IDENTIFIER_ENGINE;
    private static final IdentifierEngine OLE2_IDENTIFIER_ENGINE;

    private SigUtils() {
    }

    public static SignatureType getSigFileType(Document doc) {
        SignatureType returnValue = null;
        if (doc != null) {
            Element root = doc.getDocumentElement();
            switch (root.getNodeName()) {
                case "ContainerSignatureMapping": {
                    returnValue = SignatureType.CONTAINER;
                    break;
                }
                case "FFSignatureFile": {
                    returnValue = SignatureType.BINARY;
                    break;
                }
                default: {
                    returnValue = null;
                }
            }
        }
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ContainerSignatureDefinitions readContainerSignatures(String filename) throws SignatureParseException {
        Object containerSignatureDefinitions = null;
        if (filename == null) return null;
        Path containerSignaturesFile = Paths.get(filename, new String[0]);
        if (!Files.exists(containerSignaturesFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Container signature file not found");
        }
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(containerSignaturesFile, new OpenOption[0]));){
            ContainerSignatureSaxParser parser = new ContainerSignatureSaxParser();
            ContainerSignatureDefinitions containerSignatureDefinitions2 = parser.parse((InputStream)in);
            return containerSignatureDefinitions2;
        }
        catch (IOException | JAXBException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }

    public static FFSignatureFile readBinarySignatures(String filename) throws SignatureParseException {
        File theFile = new File(filename);
        SignatureFileParser parser = new SignatureFileParser();
        return parser.parseSigFile(theFile.toPath());
    }

    public static ByteSequence parseByteSequenceXML(Element byteSequenceElement) throws SignatureParseException {
        return (ByteSequence)SEQ_PARSER.fromXmlElement(byteSequenceElement);
    }

    public static InternalSignature parseInternalSignatureXML(Element internalSigElement) throws SignatureParseException {
        return (InternalSignature)SIG_PARSER.fromXmlElement(internalSigElement);
    }

    public static InternalSignature createInternalSignatureFromXML(String xml) {
        try {
            return SigUtils.parseInternalSignatureXML(XmlUtils.readXMLFragment(xml));
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (SignatureParseException signatureParseException) {
            // empty catch block
        }
        return null;
    }

    public static void convertSignatureFileToNewFormat(PrintStream output, String filename, SignatureType sigType, boolean spaceElements) throws IOException, SignatureParseException {
        SigUtils.convertSignatureFileToNewFormat(output, XmlUtils.readXMLFile(filename), sigType, spaceElements);
    }

    public static void convertSignatureFileToNewFormat(PrintStream output, Document doc, SignatureType sigType, boolean spaceElements) throws SignatureParseException {
        NodeList byteSequenceElements = doc.getElementsByTagName("ByteSequence");
        for (int i = 0; i < byteSequenceElements.getLength(); ++i) {
            Element byteSequence = (Element)byteSequenceElements.item(i);
            ByteSequence seq = SigUtils.parseByteSequenceXML(byteSequence);
            seq.prepareForUse();
            try {
                String expression = ByteSequenceSerializer.SERIALIZER.toPRONOMExpression(seq, sigType, spaceElements);
                byteSequence.setAttribute("Sequence", expression);
                while (byteSequence.hasChildNodes()) {
                    byteSequence.removeChild(byteSequence.getFirstChild());
                }
                continue;
            }
            catch (CompileException e) {
                throw new SignatureParseException(e.getMessage(), e);
            }
        }
        try {
            output.println(XmlUtils.toXmlString(doc, true));
        }
        catch (TransformerException e) {
            throw new SignatureParseException(e.getMessage(), e);
        }
    }

    public static void summariseSignatures(PrintStream output, String signatureFileName, SignatureType sigType, boolean spaceElements, boolean noTabs) throws IOException, SignatureParseException {
        Document doc = XmlUtils.readXMLFile(signatureFileName);
        switch (SigUtils.getSigFileType(doc)) {
            case BINARY: {
                SigUtils.summariseBinarySignatureFile(output, signatureFileName, sigType, spaceElements, noTabs);
                break;
            }
            case CONTAINER: {
                SigUtils.summariseContainerSignatureFile(output, signatureFileName, sigType, spaceElements, noTabs);
                break;
            }
            default: {
                throw new SignatureParseException("Not a binary or container signature file: " + signatureFileName);
            }
        }
    }

    public static void summariseBinarySignatureFile(PrintStream output, String signatureFileName, SignatureType sigType, boolean spaceElements, boolean noTabs) throws SignatureParseException {
        FFSignatureFile sigFile = SigUtils.readBinarySignatures(signatureFileName);
        if (!noTabs) {
            output.println("Version\tSig ID\tReference\tSequence");
        }
        SigUtils.summariseInternalSignatures(output, sigFile.getVersion(), sigFile.getSignatures(), sigType, spaceElements, noTabs);
    }

    public static void summariseContainerSignatureFile(PrintStream output, String signatureFileName, SignatureType sigType, boolean spaceElements, boolean noTabs) throws SignatureParseException {
        ContainerSignatureDefinitions sigDefs = SigUtils.readContainerSignatures(signatureFileName);
        output.println("Description\tContainer Sig ID\tContainer File\tInternal Sig ID\tReference\tSequence");
        for (ContainerSignature sig : sigDefs.getContainerSignatures()) {
            Map map = sig.getFiles();
            for (String cfilename : map.keySet()) {
                ContainerFile cFile = (ContainerFile)map.get(cfilename);
                InternalSignatureCollection sigcol = cFile.getCompiledBinarySignatures();
                if (sigcol == null) continue;
                String header = sig.getDescription() + '\t' + sig.getId() + '\t' + cfilename;
                SigUtils.summariseInternalSignatures(output, header, sigcol.getInternalSignatures(), sigType, spaceElements, noTabs);
            }
        }
    }

    public static void summariseInternalSignatures(PrintStream output, String header, List<InternalSignature> sigcol, SignatureType sigType, boolean spaceElements, boolean noTabs) throws SignatureParseException {
        for (InternalSignature isig : sigcol) {
            for (ByteSequence seq : isig.getByteSequences()) {
                try {
                    seq.prepareForUse();
                    String sequence = ByteSequenceSerializer.SERIALIZER.toPRONOMExpression(seq, sigType, spaceElements);
                    if (noTabs) {
                        output.println(sequence);
                        continue;
                    }
                    output.println(header + '\t' + isig.getID() + '\t' + seq.getReference() + '\t' + sequence);
                }
                catch (CompileException e) {
                    throw new SignatureParseException(e.getMessage(), e);
                }
            }
        }
    }

    public static void convertExpressionsToXML(PrintStream output, List<String> expressions, ByteSequenceCompiler.CompileType compileType, SignatureType sigType, ByteSequenceAnchor offset, boolean noTabs) throws CompileException {
        for (String expression : expressions) {
            String xml = ByteSequenceSerializer.SERIALIZER.toXML(expression, offset, compileType, sigType);
            if (noTabs) {
                output.println(xml);
                continue;
            }
            output.println(expression + '\t' + xml);
        }
    }

    public static void convertExpressionSyntax(PrintStream output, List<String> expressions, SignatureType sigType, boolean spaceElements, boolean noTabs) throws CompileException {
        for (String expression : expressions) {
            String xml = ByteSequenceSerializer.SERIALIZER.toPRONOMExpression(expression, sigType, spaceElements);
            if (noTabs) {
                output.println(xml);
                continue;
            }
            output.println(expression + '\t' + xml);
        }
    }

    public static void matchExpressions(PrintStream output, List<String> expressions, ByteSequenceAnchor anchor, String pathToScan) throws CompileException, IOException {
        StringBuilder expressionHeader = new StringBuilder("Expressions:");
        for (String expression : expressions) {
            expressionHeader.append('\t').append(expression);
        }
        output.println(expressionHeader.toString());
        SigUtils.matchSignatures(output, SigUtils.compileExpressions(expressions, anchor), pathToScan);
    }

    public static void matchSignatures(PrintStream output, InternalSignatureCollection sigs, String pathToScan) throws IOException {
        String pathToUse = SigUtils.getPathWithoutEndingSeparator(pathToScan);
        File scanFile = new File(pathToUse);
        if (scanFile.exists()) {
            StringBuilder header = new StringBuilder("File");
            for (int i = 0; i < sigs.getInternalSignatures().size(); ++i) {
                header.append("\tHits");
            }
            output.println(header);
            if (scanFile.isDirectory()) {
                String[] files;
                StringBuilder exceptionMessages = new StringBuilder();
                for (String filename : files = scanFile.list()) {
                    try {
                        String childPath = pathToUse + File.separator + filename;
                        File childFile = new File(childPath);
                        if (!childFile.isFile()) continue;
                        List<InternalSignature> matchingSigs = SigUtils.matchFile(childPath, sigs);
                        SigUtils.printSignatureMatches(output, childPath, sigs, matchingSigs);
                    }
                    catch (IOException e) {
                        exceptionMessages.append(IO_EXCEPTION_PROCESSING).append(filename).append(':').append(e.getMessage()).append('\n');
                    }
                }
                String failureMessages = exceptionMessages.toString();
                if (!failureMessages.isEmpty()) {
                    throw new IOException(failureMessages);
                }
            } else {
                List<InternalSignature> matchingSigs = SigUtils.matchFile(pathToUse, sigs);
                SigUtils.printSignatureMatches(output, pathToUse, sigs, matchingSigs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<InternalSignature> matchFile(String filename, InternalSignatureCollection sigs) throws IOException {
        try (ByteReader reader = null;){
            Path file = Paths.get(filename, new String[0]);
            reader = SigUtils.getByteReaderForFile(file);
            List<InternalSignature> list = sigs.getMatchingSignatures(reader, -1L);
            return list;
        }
    }

    public static void matchContainerFile(PrintStream output, String signature, String internalPath, ByteSequenceAnchor anchor, String pathToScan) throws IOException, CompileException {
        String pathToUse = SigUtils.getPathWithoutEndingSeparator(pathToScan);
        File scanFile = new File(pathToUse);
        if (scanFile.exists()) {
            output.println("File\tHit");
            if (scanFile.isDirectory()) {
                String[] files;
                StringBuilder exceptionMessages = new StringBuilder();
                for (String filename : files = scanFile.list()) {
                    try {
                        String childPath = pathToUse + File.separator + filename;
                        File childFile = new File(childPath);
                        if (!childFile.isFile()) continue;
                        if (SigUtils.matchContainerFile(filename, signature, internalPath, anchor)) {
                            output.println(filename + TAB_ONE);
                            continue;
                        }
                        output.println(filename + TAB_ZERO);
                    }
                    catch (IOException e) {
                        exceptionMessages.append(IO_EXCEPTION_PROCESSING).append(filename).append(':').append(e.getMessage()).append('\n');
                    }
                }
                String failureMessages = exceptionMessages.toString();
                if (!failureMessages.isEmpty()) {
                    throw new IOException(failureMessages);
                }
            } else if (SigUtils.matchContainerFile(pathToUse, signature, internalPath, anchor)) {
                output.println(pathToUse + TAB_ONE);
            } else {
                output.println(pathToUse + TAB_ZERO);
            }
        }
    }

    public static boolean matchContainerFile(String filename, String signature, String internalPath, ByteSequenceAnchor signatureAnchor) throws IOException, CompileException {
        ContainerSignature sig = SigUtils.createContainerSignature(1, signature, signature, internalPath, signatureAnchor);
        return SigUtils.matchContainerFile(filename, sig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean matchContainerFile(String filename, ContainerSignature sig) throws IOException {
        try (ContainerFileIdentificationRequest fileRequest = null;){
            Path file = Paths.get(filename, new String[0]);
            fileRequest = new ContainerFileIdentificationRequest(null);
            FileInputStream stream = new FileInputStream(new File(filename));
            fileRequest.open((InputStream)stream);
            boolean bl = SigUtils.matchContainerFile(filename, (IdentificationRequest)fileRequest, sig);
            return bl;
        }
    }

    public static boolean matchContainerFile(String filename, IdentificationRequest request, ContainerSignature sig) throws IOException {
        boolean result = false;
        IdentifierEngine engine = SigUtils.getContainerIdentifierEngine(filename);
        if (engine != null) {
            ContainerSignatureMatchCollection collection = SigUtils.getContainerMatchCollection(sig);
            engine.process(request, collection);
            for (ContainerSignatureMatch match : collection.getContainerSignatureMatches()) {
                if (match.isMatch()) continue;
                return false;
            }
            result = true;
        }
        return result;
    }

    public static ContainerSignatureMatchCollection getContainerMatchCollection(ContainerSignature sig) {
        ArrayList<ContainerSignature> sigs = new ArrayList<ContainerSignature>();
        sigs.add(sig);
        ArrayList filesInSig = new ArrayList(sig.getFiles().keySet());
        return new ContainerSignatureMatchCollection(sigs, filesInSig, -1L);
    }

    public static IdentifierEngine getContainerIdentifierEngine(String filename) throws IOException {
        IdentifierEngine engine = null;
        List<InternalSignature> matches = SigUtils.matchFile(filename, CONTAINER_SIGNATURES);
        if (matches.size() == 1) {
            InternalSignature sig = matches.get(0);
            switch (sig.getID()) {
                case 200: {
                    engine = ZIP_IDENTIFIER_ENGINE;
                    break;
                }
                case 170: {
                    engine = OLE2_IDENTIFIER_ENGINE;
                    break;
                }
                default: {
                    engine = null;
                }
            }
        }
        if (engine != null) {
            engine.setRequestFactory((IdentificationRequestFactory)new ContainerFileIdentificationRequestFactory());
        }
        return engine;
    }

    public static ContainerSignature createContainerSignature(int id, String description, String signature, String internalPath, ByteSequenceAnchor signatureAnchor) throws CompileException {
        InternalSignatureCollection sigs = SigUtils.compileExpression(signature, signatureAnchor);
        ContainerFile file = SigUtils.createContainerFile(sigs, internalPath);
        ArrayList<ContainerFile> files = new ArrayList<ContainerFile>();
        files.add(file);
        return SigUtils.createContainerSignature(id, description, files);
    }

    public static ContainerSignature createContainerSignature(int id, String description, List<ContainerFile> containerFiles) {
        ContainerSignature containerSig = new ContainerSignature();
        containerSig.setId(id);
        containerSig.setDescription(description);
        containerSig.setFiles(containerFiles);
        return containerSig;
    }

    public static ContainerFile createContainerFile(InternalSignatureCollection binarySigs, String containerFilePath) {
        ContainerFile containerFile = new ContainerFile();
        containerFile.setPath(containerFilePath);
        containerFile.setBinarySignatures(binarySigs);
        return containerFile;
    }

    public static ByteReader getByteReaderForFile(Path file) throws IOException {
        long size = Files.size(file);
        long lastmodified = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
        RequestMetaData metaData = new RequestMetaData(Long.valueOf(size), Long.valueOf(lastmodified), file.toString());
        RequestIdentifier identifier = new RequestIdentifier(file.toUri());
        FileSystemIdentificationRequest fileRequest = new FileSystemIdentificationRequest(metaData, identifier);
        fileRequest.open((Object)file);
        return new IdentificationRequestByteReaderAdapter((IdentificationRequest)fileRequest);
    }

    public static InternalSignatureCollection compileExpression(String expression, ByteSequenceAnchor anchor) throws CompileException {
        ArrayList<String> expressions = new ArrayList<String>();
        expressions.add(expression);
        return SigUtils.compileExpressions(expressions, anchor);
    }

    public static InternalSignatureCollection compileExpressions(List<String> expressions, ByteSequenceAnchor anchor) throws CompileException {
        int sigID = 0;
        InternalSignatureCollection sigs = new InternalSignatureCollection();
        for (String expression : expressions) {
            ByteSequence sequence = ByteSequenceCompiler.COMPILER.compile(expression, anchor);
            InternalSignature sig = new InternalSignature();
            String sigIDString = Integer.toString(sigID++);
            sig.setID(sigIDString);
            sig.addByteSequence(sequence);
            sig.addFileFormat(SigUtils.getFakeFileFormat(sigIDString));
            sig.prepareForUse();
            sigs.addInternalSignature(sig);
        }
        return sigs;
    }

    private static void printSignatureMatches(PrintStream output, String header, InternalSignatureCollection sigs, List<InternalSignature> matchingSignatures) {
        int[] hitNums = new int[sigs.getInternalSignatures().size()];
        for (InternalSignature hit : matchingSignatures) {
            hitNums[hit.getID()] = 1;
        }
        StringBuilder builder = new StringBuilder(header);
        for (int i = 0; i < hitNums.length; ++i) {
            builder.append('\t').append(hitNums[i]);
        }
        output.println(builder.toString());
    }

    private static FileFormat getFakeFileFormat(String sigID) {
        FileFormat fakeFormat = new FileFormat();
        fakeFormat.setAttributeValue("Name", "Test format: " + sigID);
        fakeFormat.setAttributeValue("PUID", "tst/" + sigID);
        fakeFormat.setInternalSignatureID(sigID);
        return fakeFormat;
    }

    private static String getPathWithoutEndingSeparator(String path) {
        if (path.endsWith(File.separator)) {
            return path.substring(0, path.length() - File.separator.length());
        }
        return path;
    }

    static {
        InternalSignature zipSig = SigUtils.createInternalSignatureFromXML(ZIP_SIG_XML);
        InternalSignature ole2Sig = SigUtils.createInternalSignatureFromXML(OLE2_SIG_XML);
        CONTAINER_SIGNATURES = new InternalSignatureCollection();
        if (zipSig != null) {
            zipSig.prepareForUse();
            CONTAINER_SIGNATURES.addInternalSignature(zipSig);
        }
        if (ole2Sig != null) {
            ole2Sig.prepareForUse();
            CONTAINER_SIGNATURES.addInternalSignature(ole2Sig);
        }
        ZIP_IDENTIFIER_ENGINE = new ZipIdentifierEngine();
        OLE2_IDENTIFIER_ENGINE = new Ole2IdentifierEngine();
    }
}

