/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.report;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.report.interfaces.ReportSpec;
import uk.gov.nationalarchives.droid.report.interfaces.ReportSpecDao;

public class JaxbReportSpecDao
implements ReportSpecDao {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ReportSpec.class});

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReportSpec readReportSpec(Path file) {
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            ReportSpec reportSpec = (ReportSpec)unmarshaller.unmarshal((Reader)reader);
            return reportSpec;
        }
        catch (JAXBException e) {
            this.log.error(e.getErrorCode(), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

