/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import uk.gov.nationalarchives.droid.core.SignatureParseException;
import uk.gov.nationalarchives.droid.core.signature.xml.SAXModelBuilder;
import uk.gov.nationalarchives.droid.core.signature.xml.SimpleElement;

public class BinarySignatureXMLParser<T extends SimpleElement> {
    private SAXParserFactory factory = SAXParserFactory.newInstance();

    public T fromXmlElement(Element element) throws SignatureParseException {
        XMLSerializer serializer = new XMLSerializer();
        StringWriter writer = new StringWriter();
        try {
            SAXParser saxParser = this.factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            SAXModelBuilder mb = new SAXModelBuilder();
            xmlReader.setContentHandler((ContentHandler)mb);
            serializer.setOutputCharStream((Writer)writer);
            serializer.serialize(element);
            String xml = writer.getBuffer().toString();
            xmlReader.parse(new InputSource(new StringReader(xml)));
            SimpleElement sig = mb.getModel();
            return (T)sig;
        }
        catch (ParserConfigurationException e) {
            throw new SignatureParseException((Throwable)e);
        }
        catch (SAXException e) {
            throw new SignatureParseException((Throwable)e);
        }
        catch (IOException e) {
            throw new SignatureParseException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new SignatureParseException((Throwable)e);
        }
    }
}

