/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.joda.time.format.ISODateTimeFormat;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.NodeStatus;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionFieldEnum;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionOperator;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterCriterion;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterValue;

@XmlAccessorType(value=XmlAccessType.NONE)
public class FilterCriterionImpl
implements FilterCriterion {
    @XmlElement(name="FieldName", required=true)
    private CriterionFieldEnum fieldName;
    @XmlElement(name="Operator", required=true)
    private CriterionOperator operator;
    @XmlElement(name="Value", required=true)
    private String valueFreeText;
    @XmlElement(name="Parameter", required=true)
    private List<FilterValue> selectedValues = new ArrayList<FilterValue>();
    @XmlElement(name="RowNumber", required=true)
    private int rowNumber;

    public FilterCriterionImpl() {
    }

    public FilterCriterionImpl(CriterionFieldEnum field, CriterionOperator operator, String valueFreeText, List<FilterValue> selectedValues, int rowNumber) {
        this.setField(field);
        this.setOperator(operator);
        this.setValueFreeText(valueFreeText);
        this.setSelectedValues(selectedValues);
        this.setRowNumber(rowNumber);
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public void addSelectedValue(FilterValue value) {
        this.selectedValues.add(value);
    }

    public void removeSelectedValues(FilterValue value) {
        int index = 0;
        for (int i = 0; i < this.selectedValues.size(); ++i) {
            if (this.selectedValues.get(i).getDescription().equals(value.getDescription())) {
                index = i;
            }
            if (index < 0) continue;
            this.selectedValues.remove(index);
        }
    }

    public CriterionFieldEnum getField() {
        return this.fieldName;
    }

    public void setField(CriterionFieldEnum field) {
        this.fieldName = field;
    }

    public CriterionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(CriterionOperator operator) {
        this.operator = operator;
    }

    public String getValueFreeText() {
        return this.valueFreeText;
    }

    public void setValueFreeText(String valueFreeText) {
        this.valueFreeText = valueFreeText;
    }

    public List<FilterValue> getSelectedValues() {
        return this.selectedValues;
    }

    public void setSelectedValues(List<FilterValue> selectedValues) {
        this.selectedValues = selectedValues;
    }

    public Object getValue() {
        Object[] obj = null;
        if (this.selectedValues != null && !this.selectedValues.isEmpty()) {
            Object[] value = new Object[this.selectedValues.size()];
            int i = 0;
            for (FilterValue v : this.selectedValues) {
                value[i++] = FilterCriterionImpl.convert(this.fieldName, v.getQueryParameter());
            }
            obj = value;
        } else if (this.valueFreeText != null) {
            obj = FilterCriterionImpl.convert(this.fieldName, this.valueFreeText);
        }
        return obj;
    }

    private static Object convert(CriterionFieldEnum fieldType, String s) {
        Object o;
        switch (fieldType) {
            case FILE_EXTENSION: 
            case FILE_NAME: 
            case FILE_FORMAT: {
                o = s.toUpperCase();
                break;
            }
            case PUID: 
            case MIME_TYPE: {
                o = s;
                break;
            }
            case FILE_SIZE: {
                o = Long.valueOf(s);
                break;
            }
            case LAST_MODIFIED_DATE: {
                o = ISODateTimeFormat.date().parseDateTime(s).toDate();
                break;
            }
            case IDENTIFICATION_METHOD: {
                o = IdentificationMethod.values()[Integer.valueOf(s)].ordinal();
                break;
            }
            case JOB_STATUS: {
                o = NodeStatus.values()[Integer.valueOf(s)].ordinal();
                break;
            }
            case RESOURCE_TYPE: {
                o = ResourceType.values()[Integer.valueOf(s)].ordinal();
                break;
            }
            case IDENTIFICATION_COUNT: {
                o = Integer.valueOf(s);
                break;
            }
            case EXTENSION_MISMATCH: {
                o = Boolean.valueOf(s);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid argument [%s]", fieldType));
            }
        }
        return o;
    }
}

