/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.NodeStatus;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.QueryBuilder;
import uk.gov.nationalarchives.droid.profile.NodeMetaData;
import uk.gov.nationalarchives.droid.profile.ProfileDao;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.SqlUtils;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;
import uk.gov.nationalarchives.droid.results.handlers.JDBCBatchResultHandlerDao;
import uk.gov.nationalarchives.droid.results.handlers.ResultHandlerDao;

public class JDBCProfileDao
implements ProfileDao {
    public static final RowMapper<ProfileResourceNode> PROFILE_RESOURCE_NODE_ROW_MAPPER_WITH_FILTER = new RowMapper<ProfileResourceNode>(){

        public ProfileResourceNode mapRow(ResultSet rs, int rowNum) throws SQLException {
            ProfileResourceNode node = (ProfileResourceNode)PROFILE_RESOURCE_NODE_ROW_MAPPER.mapRow(rs, rowNum);
            node.setFilterStatus(rs.getInt("FILTERSTATUS"));
            return node;
        }
    };
    public static final RowMapper<ProfileResourceNode> PROFILE_RESOURCE_NODE_ROW_MAPPER_WITH_EMPTY_FOLDER = new RowMapper<ProfileResourceNode>(){

        public ProfileResourceNode mapRow(ResultSet rs, int rowNum) throws SQLException {
            ProfileResourceNode node = (ProfileResourceNode)PROFILE_RESOURCE_NODE_ROW_MAPPER.mapRow(rs, rowNum);
            NodeMetaData nodeMetaData = node.getMetaData();
            boolean emptyDir = rs.getBoolean("EMPTY_DIR");
            if (emptyDir && nodeMetaData.getNodeStatus() == NodeStatus.DONE) {
                nodeMetaData.setNodeStatus(NodeStatus.EMPTY);
            }
            return node;
        }
    };
    public static final RowMapper<ProfileResourceNode> PROFILE_RESOURCE_NODE_ROW_MAPPER = new RowMapper<ProfileResourceNode>(){

        public ProfileResourceNode mapRow(ResultSet rs, int rowNum) throws SQLException {
            URI uri;
            String uriString = rs.getString("URI");
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException e) {
                throw new SQLException("The URI for the node obtained from the database: [" + uriString + "] could not be converted into a URI", e);
            }
            NodeMetaData nodeMetaData = new NodeMetaData();
            ProfileResourceNode node = new ProfileResourceNode(uri);
            node.setMetaData(nodeMetaData);
            node.setId(rs.getLong("NODE_ID"));
            node.setExtensionMismatch(rs.getBoolean("EXTENSION_MISMATCH"));
            node.setFinished(SqlUtils.getNullableTimestamp("FINISHED_TIMESTAMP", rs));
            nodeMetaData.setExtension(SqlUtils.getNullableString("EXTENSION", rs));
            nodeMetaData.setHash(SqlUtils.getNullableString("HASH", rs));
            Integer identificationMethodIndex = SqlUtils.getNullableInteger("IDENTIFICATION_METHOD", rs);
            nodeMetaData.setIdentificationMethod(identificationMethodIndex == null ? null : IdentificationMethod.values()[identificationMethodIndex]);
            nodeMetaData.setLastModifiedDate(SqlUtils.getNullableTimestamp("LAST_MODIFIED_DATE", rs));
            nodeMetaData.setName(rs.getString("NAME"));
            Integer nodeStatusIndex = SqlUtils.getNullableInteger("NODE_STATUS", rs);
            nodeMetaData.setNodeStatus(nodeStatusIndex == null ? null : NodeStatus.values()[nodeStatusIndex]);
            nodeMetaData.setResourceType(ResourceType.values()[rs.getInt("RESOURCE_TYPE")]);
            nodeMetaData.setSize(SqlUtils.getNullableLong("FILE_SIZE", rs));
            node.setParentId(SqlUtils.getNullableLong("PARENT_ID", rs));
            node.setPrefix(SqlUtils.getNullableString("PREFIX", rs));
            node.setPrefixPlusOne(SqlUtils.getNullableString("PREFIX_PLUS_ONE", rs));
            node.setFilterStatus(1);
            return node;
        }
    };
    private static final String INSERT_FORMAT = "INSERT INTO FORMAT (PUID,MIME_TYPE,NAME,VERSION) VALUES (?,?,?,?)";
    private static final String SELECT_MAIN = "SELECT NODE_ID, EXTENSION_MISMATCH, FINISHED_TIMESTAMP, IDENTIFICATION_COUNT, EXTENSION, HASH, IDENTIFICATION_METHOD, LAST_MODIFIED_DATE, NAME, NODE_STATUS, RESOURCE_TYPE, FILE_SIZE, PARENT_ID, PREFIX, PREFIX_PLUS_ONE, TEXT_ENCODING, URI, CASE \n\t\t  WHEN NODES.RESOURCE_TYPE = 0 THEN \n\t\t  \tCASE\n\t\t  \t\twhen NOT EXISTS(SELECT NODE2.PARENT_ID FROM PROFILE_RESOURCE_NODE NODE2 WHERE NODE2.PARENT_ID = NODES.NODE_ID) then true\n\t\t  \t\telse false\n\t\t  \tEND\n\t\t  ELSE false\n\t\tEND as EMPTY_DIR FROM PROFILE_RESOURCE_NODE NODES ";
    private static final String FIND_CHILD_NODES = "SELECT NODE_ID, EXTENSION_MISMATCH, FINISHED_TIMESTAMP, IDENTIFICATION_COUNT, EXTENSION, HASH, IDENTIFICATION_METHOD, LAST_MODIFIED_DATE, NAME, NODE_STATUS, RESOURCE_TYPE, FILE_SIZE, PARENT_ID, PREFIX, PREFIX_PLUS_ONE, TEXT_ENCODING, URI, CASE \n\t\t  WHEN NODES.RESOURCE_TYPE = 0 THEN \n\t\t  \tCASE\n\t\t  \t\twhen NOT EXISTS(SELECT NODE2.PARENT_ID FROM PROFILE_RESOURCE_NODE NODE2 WHERE NODE2.PARENT_ID = NODES.NODE_ID) then true\n\t\t  \t\telse false\n\t\t  \tEND\n\t\t  ELSE false\n\t\tEND as EMPTY_DIR FROM PROFILE_RESOURCE_NODE NODES WHERE PARENT_ID=?";
    private static final String FIND_TOP_LEVEL_CHILDREN = "SELECT NODE_ID, EXTENSION_MISMATCH, FINISHED_TIMESTAMP, IDENTIFICATION_COUNT, EXTENSION, HASH, IDENTIFICATION_METHOD, LAST_MODIFIED_DATE, NAME, NODE_STATUS, RESOURCE_TYPE, FILE_SIZE, PARENT_ID, PREFIX, PREFIX_PLUS_ONE, TEXT_ENCODING, URI, CASE \n\t\t  WHEN NODES.RESOURCE_TYPE = 0 THEN \n\t\t  \tCASE\n\t\t  \t\twhen NOT EXISTS(SELECT NODE2.PARENT_ID FROM PROFILE_RESOURCE_NODE NODE2 WHERE NODE2.PARENT_ID = NODES.NODE_ID) then true\n\t\t  \t\telse false\n\t\t  \tEND\n\t\t  ELSE false\n\t\tEND as EMPTY_DIR FROM PROFILE_RESOURCE_NODE NODES WHERE PARENT_ID IS NULL";
    private static final String FIND_CHILDREN = "SELECT ID.NODE_ID, ID.PUID FROM IDENTIFICATION AS ID INNER JOIN PROFILE_RESOURCE_NODE AS PRN ON ID.NODE_ID = PRN.NODE_ID";
    private static final String FIND_CHILD_IDS = "SELECT ID.NODE_ID, ID.PUID FROM IDENTIFICATION AS ID INNER JOIN PROFILE_RESOURCE_NODE AS PRN ON ID.NODE_ID = PRN.NODE_ID AND PRN.PARENT_ID = ?";
    private static final String FIND_TOP_LEVEL_CHILD_IDS = "SELECT ID.NODE_ID, ID.PUID FROM IDENTIFICATION AS ID INNER JOIN PROFILE_RESOURCE_NODE AS PRN ON ID.NODE_ID = PRN.NODE_ID AND PRN.PARENT_ID IS NULL";
    private static final String dummyPuid = "INSERT INTO FORMAT (PUID,MIME_TYPE,NAME,VERSION) VALUES ('','','','')";
    private static final int FORMAT_PUID_INDEX = 1;
    private static final int FORMAT_MIME_TYPE_INDEX = 2;
    private static final int FORMAT_NAME_INDEX = 3;
    private static final int FORMAT_VERSION_INDEX = 4;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private DataSource datasource;
    private ResultHandlerDao resultHandlerDao;
    private JdbcTemplate jdbcTemplate;

    public JDBCProfileDao() {
    }

    public JDBCProfileDao(DataSource datasource, ResultHandlerDao resultHandlerDao) {
        this.setDatasource(datasource);
        this.setResultHandlerDao(resultHandlerDao);
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
        this.jdbcTemplate = new JdbcTemplate(datasource);
    }

    public void setResultHandlerDao(ResultHandlerDao resultHandlerDao) {
        this.resultHandlerDao = resultHandlerDao;
    }

    @Override
    public List<Format> getAllFormats() {
        return this.resultHandlerDao.getAllFormats();
    }

    @Override
    public void saveFormat(final Format format) {
        try {
            this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Void>(){

                public Void doInConnection(Connection conn) throws SQLException {
                    try (PreparedStatement insertFormat = format == Format.NULL ? conn.prepareStatement(JDBCProfileDao.dummyPuid) : JDBCProfileDao.this.getInsertFormatStatement(conn, format);){
                        insertFormat.execute();
                        conn.commit();
                    }
                    return null;
                }
            });
        }
        catch (DataAccessException ex) {
            String exceptionFormatString = "A database exception occurred inserting a format " + (format == null ? "NULL" : format.toString());
            this.log.error(exceptionFormatString, (Throwable)ex);
        }
    }

    private PreparedStatement getInsertFormatStatement(Connection conn, Format format) throws SQLException {
        PreparedStatement insertFormat = conn.prepareStatement(INSERT_FORMAT);
        insertFormat.setString(1, format.getPuid());
        SqlUtils.setNullableString(2, format.getMimeType(), insertFormat);
        SqlUtils.setNullableString(3, format.getName(), insertFormat);
        SqlUtils.setNullableString(4, format.getVersion(), insertFormat);
        return insertFormat;
    }

    @Override
    public List<ProfileResourceNode> findProfileResourceNodes(Long parentId) {
        try {
            List childNodes = parentId == null ? this.jdbcTemplate.query(FIND_TOP_LEVEL_CHILDREN, PROFILE_RESOURCE_NODE_ROW_MAPPER_WITH_EMPTY_FOLDER) : this.jdbcTemplate.query(FIND_CHILD_NODES, PROFILE_RESOURCE_NODE_ROW_MAPPER_WITH_EMPTY_FOLDER, new Object[]{parentId});
            this.loadIdentifications(parentId, childNodes);
            return childNodes;
        }
        catch (DataAccessException ex) {
            this.log.error("A database exception occurred finding nodes with parent id " + parentId, (Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public List<ProfileResourceNode> findProfileResourceNodes(Long parentId, Filter filter) {
        QueryBuilder queryBuilder = SqlUtils.getQueryBuilder(filter);
        String ejbFilter = queryBuilder.toEjbQl();
        String query = this.getSQLQueryString(ejbFilter, parentId);
        try {
            Object[] queryParameters = queryBuilder.getValues();
            Object[] doubleParameters = null;
            if (parentId == null) {
                doubleParameters = new Object[queryParameters.length * 2];
            } else {
                doubleParameters = new Object[queryParameters.length * 2 + 1];
                doubleParameters[doubleParameters.length - 1] = parentId;
            }
            System.arraycopy(queryParameters, 0, doubleParameters, 0, queryParameters.length);
            System.arraycopy(queryParameters, 0, doubleParameters, queryParameters.length, queryParameters.length);
            List nodes = this.jdbcTemplate.query(query, PROFILE_RESOURCE_NODE_ROW_MAPPER_WITH_FILTER, doubleParameters);
            ArrayList<ProfileResourceNode> filteredNodes = new ArrayList<ProfileResourceNode>();
            for (ProfileResourceNode node : nodes) {
                if (node.getFilterStatus() <= 0) continue;
                filteredNodes.add(node);
            }
            this.loadIdentifications(parentId, filteredNodes);
            return filteredNodes;
        }
        catch (DataAccessException ex) {
            String exceptionParentString = "A database exception occurred finding filtered nodes with parent id " + (parentId == null ? "NULL" : parentId);
            this.log.error(exceptionParentString, (Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public void initialise() {
        this.populateResultHandlerReferenceData();
    }

    private void loadIdentifications(Long parentId, final List<ProfileResourceNode> childNodes) {
        if (childNodes.size() > 0) {
            ResultSetExtractor extractor = new ResultSetExtractor(){

                public Object extractData(ResultSet rs) throws SQLException {
                    JDBCProfileDao.this.addIdentificationsToNodes(rs, childNodes, JDBCProfileDao.this.resultHandlerDao.getPUIDFormatMap());
                    return null;
                }
            };
            if (parentId == null) {
                this.jdbcTemplate.query(FIND_TOP_LEVEL_CHILD_IDS, extractor);
            } else {
                this.jdbcTemplate.query(FIND_CHILD_IDS, new Object[]{parentId}, extractor);
            }
        }
    }

    private String getSQLQueryString(String ejbFilter, Long parentId) {
        boolean formatCriteriaExist = this.formatCriteriaExist(ejbFilter);
        boolean formatMetadataExist = formatCriteriaExist && this.formatMetadataExist(ejbFilter);
        String filterCriteriaDirect = SqlUtils.transformEJBtoSQLFields(ejbFilter, "profile", "form");
        String filterCriteriaChild = SqlUtils.transformEJBtoSQLFields(ejbFilter, "children", "child_form");
        String query = formatCriteriaExist ? "select distinct profile.*," : "select profile.*,";
        query = query + " case when (" + filterCriteriaDirect + ") then 1 else case when profile.resource_type <> 2 and exists ( select children.node_id from profile_resource_node as children";
        if (formatCriteriaExist) {
            query = formatMetadataExist ? query + " inner join identification as child_ident on child_ident.node_id = children.node_id inner join format as child_form on child_form.puid = child_ident.puid" : query + " inner join identification as child_form on child_form.node_id = children.node_id";
        }
        query = query + " where children.prefix > profile.prefix and children.prefix < profile.prefix_plus_one and (" + filterCriteriaChild + ")) then 2 else 0 end end as FilterStatus from profile_resource_node as profile";
        if (formatCriteriaExist) {
            query = formatMetadataExist ? query + " inner join identification as ident on ident.node_id = profile.node_id inner join format as form on form.puid = ident.puid" : query + " inner join identification as form on form.node_id = profile.node_id";
        }
        return query + " where profile.parent_id " + this.getParentIdQuery(parentId);
    }

    private boolean formatCriteriaExist(String filter) {
        return filter.contains("format.");
    }

    private boolean formatMetadataExist(String filter) {
        return filter.contains("format.mimeType") || filter.contains("format.name");
    }

    private void addIdentificationsToNodes(ResultSet identifications, List<ProfileResourceNode> childNodes, Map<String, Format> puidFormatMap) throws SQLException {
        Map<Long, ProfileResourceNode> nodeIdMap = this.buildNodeIdMap(childNodes);
        while (identifications.next()) {
            ProfileResourceNode node = nodeIdMap.get(identifications.getLong(1));
            Format format = puidFormatMap.get(identifications.getString(2));
            if (node != null && format != null) {
                node.addFormatIdentification(format);
            }
            for (ProfileResourceNode child : childNodes) {
                if (child.getIdentificationCount() != null || child.getMetaData().getResourceType() == ResourceType.FOLDER) continue;
                child.setZeroIdentifications();
            }
        }
    }

    private Map<Long, ProfileResourceNode> buildNodeIdMap(List<ProfileResourceNode> nodes) {
        HashMap<Long, ProfileResourceNode> nodeIdMap = new HashMap<Long, ProfileResourceNode>(nodes.size() * 2);
        for (ProfileResourceNode node : nodes) {
            nodeIdMap.put(node.getId(), node);
        }
        return nodeIdMap;
    }

    private String getParentIdQuery(Long parentId) {
        return parentId == null ? "is null" : " = ?";
    }

    private void populateResultHandlerReferenceData() {
        if (this.resultHandlerDao instanceof JDBCBatchResultHandlerDao) {
            JDBCBatchResultHandlerDao batchResultHandler = (JDBCBatchResultHandlerDao)this.resultHandlerDao;
            batchResultHandler.initialiseForNewTemplate();
        }
    }
}

