/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileSpecDao;

public class JaxbProfileSpecDao
implements ProfileSpecDao {
    private static final String PROFILE_XML = "profile.xml";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ProfileInstance.class});

    @Override
    public ProfileInstance loadProfile(InputStream in) {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            ProfileInstance profile = (ProfileInstance)unmarshaller.unmarshal(in);
            return profile;
        }
        catch (JAXBException e) {
            this.log.error(e.getErrorCode(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void saveProfile(ProfileInstance profile, Path profileHomeDir) {
        Path profileXml = profileHomeDir.resolve(PROFILE_XML);
        try (BufferedWriter out = Files.newBufferedWriter(profileXml, StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
            Marshaller m = this.context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)profile, (Writer)out);
        }
        catch (IOException | JAXBException e) {
            this.log.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }
}

