/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.net.URI;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.profile.AbstractProfileResource;
import uk.gov.nationalarchives.droid.profile.FilterImpl;
import uk.gov.nationalarchives.droid.profile.ProfileEventListener;
import uk.gov.nationalarchives.droid.profile.ProfileSpec;
import uk.gov.nationalarchives.droid.profile.ProfileState;
import uk.gov.nationalarchives.droid.profile.ProgressState;

@XmlRootElement(name="Profile")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProfileInstance {
    @XmlTransient
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @XmlAttribute(name="Id")
    private String uuid;
    @XmlElement(name="CreatedDate", required=true)
    private Date dateCreated;
    @XmlElement(name="Name", required=true)
    private String name;
    @XmlElement(name="ProfileSpec", required=true)
    private ProfileSpec profileSpec;
    @XmlElement(name="State", required=true)
    private ProfileState profileState;
    @XmlElement(name="SignatureFileVersion", required=true)
    private Integer signatureFileVersion;
    @XmlElement(name="ContainerSignatureFileVersion", required=true)
    private Integer containerSignatureFileVersion;
    @XmlElement(name="TextSignatureFileVersion", required=false)
    private Integer textSignatureFileVersion;
    @XmlTransient
    private Path loadedFrom;
    @XmlTransient
    private boolean dirty = true;
    @XmlElement(name="Filter", required=true)
    private FilterImpl filter;
    @XmlElement(name="Throttle")
    private int throttle;
    @XmlElement(name="SignatureFileName")
    private String signatureFileName;
    @XmlElement(name="ContainerSignatureFileName")
    private String containerSignatureFileName;
    @XmlElement(name="TextSignatureFileName")
    private String textSignatureFileName;
    @XmlElement(name="EndDate")
    private Date profileEndDate;
    @XmlElement(name="StartDate")
    private Date profileStartDate;
    @XmlTransient
    private ProfileState transientState;
    @XmlElement(name="Progress")
    private ProgressState progress;
    @XmlElement(name="GenerateHash")
    private Boolean generateHash;
    @XmlElement(name="HashAlgorithm")
    private String hashAlgorithm;
    @XmlElement(name="ProcessTarFiles")
    private Boolean processTarFiles;
    @XmlElement(name="ProcessZipFiles")
    private Boolean processZipFiles;
    @XmlElement(name="ProcessRarFiles")
    private Boolean processRarFiles;
    @XmlElement(name="ProcessGzipFiles")
    private Boolean processGzipFiles;
    @XmlElement(name="Process7zipFiles")
    private Boolean process7zipFiles;
    @XmlElement(name="ProcessIsoFiles")
    private Boolean processIsoFiles;
    @XmlElement(name="ProcessBzip2Files")
    private Boolean processBzip2Files;
    @XmlElement(name="ProcessArcFiles")
    private Boolean processArcFiles;
    @XmlElement(name="ProcessWarcFiles")
    private Boolean processWarcFiles;
    @XmlElement(name="MaxBytesToScan")
    private Long maxBytesToScan;
    @XmlElement(name="MatchAllExtensions")
    private Boolean matchAllExtensions;
    @XmlTransient
    private Set<ProfileEventListener> eventListeners = new HashSet<ProfileEventListener>();

    ProfileInstance(ProfileState state) {
        this();
        this.transientState = state;
    }

    ProfileInstance() {
        this.dateCreated = new Date();
    }

    public FilterImpl getFilter() {
        if (this.filter == null) {
            this.filter = new FilterImpl();
        }
        return this.filter;
    }

    public void setFilter(FilterImpl filter) {
        this.filter = filter;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public String getUuid() {
        return this.uuid;
    }

    void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ProfileSpec getProfileSpec() {
        return this.profileSpec;
    }

    public void setProfileSpec(ProfileSpec profileSpec) {
        this.profileSpec = profileSpec;
        this.dirty = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean addResource(AbstractProfileResource resource) {
        boolean success = this.profileSpec.addResource(resource);
        if (success) {
            this.dirty = true;
            this.fireListeners();
        }
        return success;
    }

    public boolean removeResource(URI uri) {
        boolean success = this.profileSpec.removeResource(uri);
        if (success) {
            this.dirty = true;
            this.fireListeners();
        }
        return success;
    }

    void start() {
        this.setProfileStartDate(new Date());
        this.changeState(ProfileState.RUNNING);
        this.dirty = true;
    }

    void finish() {
        this.setProfileEndDate(new Date());
        this.changeState(ProfileState.FINISHED);
    }

    void stop() {
        this.changeState(ProfileState.STOPPED);
    }

    public void changeState(ProfileState newState) {
        this.log.info(String.format("Attempting state change [%s] to [%s]", new Object[]{this.getState(), newState}));
        if (!this.getState().allowedNextStates().contains((Object)newState)) {
            throw new IllegalStateException(String.format("Illegal attempt to transition state from [%s] to [%s]", new Object[]{this.getState(), newState}));
        }
        if (newState.isTransient()) {
            this.transientState = newState;
        } else {
            this.transientState = null;
            this.profileState = newState;
        }
        this.fireListeners();
    }

    void fireListeners() {
        for (ProfileEventListener listener : this.eventListeners) {
            listener.fireEvent(this);
        }
    }

    public Integer getSignatureFileVersion() {
        return this.signatureFileVersion;
    }

    public void setSignatureFileVersion(Integer signatureFileVersion) {
        this.signatureFileVersion = signatureFileVersion;
    }

    public Path getLoadedFrom() {
        return this.loadedFrom;
    }

    public void setLoadedFrom(Path loadedFrom) {
        this.loadedFrom = loadedFrom;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public ProfileState getState() {
        return this.transientState != null ? this.transientState : this.profileState;
    }

    public void onLoad() {
        this.dirty = false;
        this.fireListeners();
    }

    public void onSave() {
        this.dirty = false;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.fireListeners();
    }

    void setThrottle(int throttle) {
        this.throttle = throttle;
    }

    public int getThrottle() {
        return this.throttle;
    }

    public String getSignatureFileName() {
        return this.signatureFileName;
    }

    public void setSignatureFileName(String signatureFileName) {
        this.signatureFileName = signatureFileName;
    }

    public Date getProfileEndDate() {
        return this.profileEndDate;
    }

    public void setProfileEndDate(Date profileEndDate) {
        this.profileEndDate = profileEndDate;
    }

    public Date getProfileStartDate() {
        return this.profileStartDate;
    }

    public void setProfileStartDate(Date profileStartDate) {
        this.profileStartDate = profileStartDate;
    }

    public void addEventListener(ProfileEventListener listener) {
        this.eventListeners.add(listener);
    }

    public ProgressState getProgress() {
        return this.progress;
    }

    public void setProgress(ProgressState progress) {
        this.progress = progress;
    }

    public void setContainerSignatureFileName(String containerSignatureFileName) {
        this.containerSignatureFileName = containerSignatureFileName;
    }

    public void setContainerSignatureFileVersion(Integer containerSignatureFileVersion) {
        this.containerSignatureFileVersion = containerSignatureFileVersion;
    }

    public void setTextSignatureFileName(String textSignatureFileName) {
        this.textSignatureFileName = textSignatureFileName;
    }

    public void setTextSignatureFileVersion(Integer textSignatureFileVersion) {
        this.textSignatureFileVersion = textSignatureFileVersion;
    }

    public String getContainerSignatureFileName() {
        return this.containerSignatureFileName;
    }

    public Integer getContainerSignatureFileVersion() {
        return this.containerSignatureFileVersion;
    }

    public String getTextSignatureFileName() {
        return this.textSignatureFileName;
    }

    public Integer getTextSignatureFileVersion() {
        return this.textSignatureFileVersion;
    }

    public Boolean getGenerateHash() {
        return this.generateHash;
    }

    public void setGenerateHash(boolean generateHash) {
        this.generateHash = generateHash;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public Boolean getProcessTarFiles() {
        return this.processTarFiles;
    }

    public void setProcessTarFiles(Boolean processTarFiles) {
        this.processTarFiles = processTarFiles;
    }

    public Boolean getProcessZipFiles() {
        return this.processZipFiles;
    }

    public void setProcessZipFiles(Boolean processZipFiles) {
        this.processZipFiles = processZipFiles;
    }

    public Long getMaxBytesToScan() {
        return this.maxBytesToScan;
    }

    public void setMaxBytesToScan(long maxBytesToScan) {
        this.maxBytesToScan = maxBytesToScan;
    }

    public void setMatchAllExtensions(Boolean matchAllExtensions) {
        this.matchAllExtensions = matchAllExtensions;
    }

    public Boolean getMatchAllExtensions() {
        return this.matchAllExtensions;
    }

    public Boolean getProcessRarFiles() {
        return this.processRarFiles;
    }

    public void setProcessRarFiles(Boolean processRarFiles) {
        this.processRarFiles = processRarFiles;
    }

    public Boolean getProcessGzipFiles() {
        return this.processGzipFiles;
    }

    public void setProcessGzipFiles(Boolean processGzipFiles) {
        this.processGzipFiles = processGzipFiles;
    }

    public Boolean getProcess7zipFiles() {
        return this.process7zipFiles;
    }

    public void setProcess7zipFiles(Boolean process7zipFiles) {
        this.process7zipFiles = process7zipFiles;
    }

    public Boolean getProcessIsoFiles() {
        return this.processIsoFiles;
    }

    public void setProcessIsoFiles(Boolean processIsoFiles) {
        this.processIsoFiles = processIsoFiles;
    }

    public Boolean getProcessBzip2Files() {
        return this.processBzip2Files;
    }

    public void setProcessBzip2Files(Boolean processBzip2Files) {
        this.processBzip2Files = processBzip2Files;
    }

    public void setProcessArcFiles(Boolean processArcFiles) {
        this.processArcFiles = processArcFiles;
    }

    public Boolean getProcessArcFiles() {
        return this.processArcFiles;
    }

    public void setProcessWarcFiles(Boolean processWarcFiles) {
        this.processWarcFiles = processWarcFiles;
    }

    public Boolean getProcessWarcFiles() {
        return this.processWarcFiles;
    }
}

