/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import uk.gov.nationalarchives.droid.profile.NodeMetaData;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;

public class ProfileResourceNode {
    private Long id;
    private Long parentId;
    private URI uri;
    private String prefix;
    private String prefixPlusOne;
    private Integer identificationCount;
    private Date finished;
    private Boolean extensionMismatch = false;
    private List<Format> formatIdentifications = new ArrayList<Format>();
    private Integer filterStatus = 1;
    private NodeMetaData metaData = new NodeMetaData();

    public ProfileResourceNode() {
    }

    public ProfileResourceNode(ProfileResourceNode toCopy) {
        this.id = toCopy.id;
        this.parentId = toCopy.parentId;
        this.uri = toCopy.uri;
        this.prefix = toCopy.prefix;
        this.prefixPlusOne = toCopy.prefixPlusOne;
        this.identificationCount = toCopy.identificationCount;
        this.finished = toCopy.finished;
        this.extensionMismatch = toCopy.extensionMismatch;
        this.formatIdentifications = new ArrayList<Format>(toCopy.formatIdentifications);
        this.filterStatus = toCopy.filterStatus;
        this.metaData = new NodeMetaData(toCopy.metaData);
    }

    public ProfileResourceNode(URI uri) {
        this.uri = uri;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean allowsChildren() {
        return this.metaData.getResourceType().allowsChildren();
    }

    public NodeMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(NodeMetaData metaData) {
        this.metaData = metaData;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uri).toHashCode();
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfileResourceNode other = (ProfileResourceNode)obj;
        return new EqualsBuilder().append((Object)this.uri, (Object)other.uri).isEquals();
    }

    public String toString() {
        return URLDecoder.decode(this.uri.toString());
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefixPlusOne() {
        return this.prefixPlusOne;
    }

    public void setPrefixPlusOne(String prefixPlusOne) {
        this.prefixPlusOne = prefixPlusOne;
    }

    public void addFormatIdentification(Format formatIdentification) {
        this.formatIdentifications.add(formatIdentification);
        if (!formatIdentification.equals(Format.NULL)) {
            if (this.identificationCount == null) {
                this.setZeroIdentifications();
            }
            Integer n = this.identificationCount;
            Integer n2 = this.identificationCount = Integer.valueOf(this.identificationCount + 1);
        }
    }

    public void setZeroIdentifications() {
        this.identificationCount = 0;
    }

    public List<Format> getFormatIdentifications() {
        return Collections.unmodifiableList(this.formatIdentifications);
    }

    public Integer getIdentificationCount() {
        return this.identificationCount;
    }

    public void setFilterStatus(Integer status) {
        this.filterStatus = status;
    }

    public int getFilterStatus() {
        return this.filterStatus;
    }

    public void setNoFormatsIdentified() {
        this.identificationCount = null;
    }

    public Boolean getExtensionMismatch() {
        return this.extensionMismatch;
    }

    public void setExtensionMismatch(Boolean extensionMismatch) {
        this.extensionMismatch = extensionMismatch;
    }

    public void setFinished(Date date) {
        this.finished = date;
    }

    public Date getFinished() {
        return this.finished;
    }
}

