/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.util.Arrays;
import java.util.Collection;

public enum ProfileState {
    RUNNING(true){

        @Override
        ProfileState[] nextStates() {
            return new ProfileState[]{STOPPED, FINISHED};
        }
    }
    ,
    STOPPED(false, true){

        @Override
        ProfileState[] nextStates() {
            return new ProfileState[]{RUNNING, SAVING, FINISHED};
        }
    }
    ,
    SAVING(true){

        @Override
        ProfileState[] nextStates() {
            return new ProfileState[]{VIRGIN, STOPPED, FINISHED};
        }
    }
    ,
    LOADING(true){

        @Override
        ProfileState[] nextStates() {
            return new ProfileState[]{VIRGIN, STOPPED, FINISHED};
        }
    }
    ,
    INITIALISING(true){

        @Override
        ProfileState[] nextStates() {
            return new ProfileState[]{VIRGIN, STOPPED, FINISHED};
        }
    }
    ,
    VIRGIN(false){

        @Override
        ProfileState[] nextStates() {
            return new ProfileState[]{RUNNING, SAVING};
        }
    }
    ,
    FINISHED(false, true){

        @Override
        ProfileState[] nextStates() {
            return new ProfileState[]{SAVING};
        }
    };

    private boolean isTransient;
    private boolean reportable;

    private ProfileState(boolean isTransient) {
        this.isTransient = isTransient;
    }

    private ProfileState(boolean isTransient, boolean reportable) {
        this.isTransient = isTransient;
        this.reportable = reportable;
    }

    abstract ProfileState[] nextStates();

    public Collection<ProfileState> allowedNextStates() {
        return Arrays.asList(this.nextStates());
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isReportable() {
        return this.reportable;
    }
}

