/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.xml.sax.EntityResolver;
import uk.gov.nationalarchives.droid.profile.ProfileException;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileInstanceLocator;
import uk.gov.nationalarchives.droid.profile.ProfileInstanceManager;
import uk.gov.nationalarchives.droid.profile.datasource.DerbyPooledDataSource;

public class SpringProfileInstanceFactory
implements ProfileInstanceLocator {
    private static final String DATA_SOURCE_BEAN_NAME = "dataSource";
    private static final String PROFILE_MANAGER = "profileManager";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, GenericApplicationContext> profileInstanceManagers = new HashMap<String, GenericApplicationContext>();

    @Override
    public synchronized ProfileInstanceManager getProfileInstanceManager(ProfileInstance profile, Properties properties) {
        GenericApplicationContext ctx;
        if (!this.profileInstanceManagers.containsKey(profile.getUuid())) {
            ctx = new GenericApplicationContext();
            XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
            xmlReader.loadBeanDefinitions((Resource[])new ClassPathResource[]{new ClassPathResource("META-INF/spring-jpa.xml"), new ClassPathResource("META-INF/spring-results.xml")});
            xmlReader.setResourceLoader((ResourceLoader)ctx);
            xmlReader.setEntityResolver((EntityResolver)new ResourceEntityResolver((ResourceLoader)ctx));
            PropertyPlaceholderConfigurer config = new PropertyPlaceholderConfigurer();
            config.setLocalOverride(true);
            config.setProperties(properties);
            config.setLocations((Resource[])new ClassPathResource[]{new ClassPathResource("jpa.properties"), new ClassPathResource("archive-puids.properties")});
            ctx.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)config);
            ctx.refresh();
            this.profileInstanceManagers.put(profile.getUuid(), ctx);
        }
        ctx = (ApplicationContext)this.profileInstanceManagers.get(profile.getUuid());
        ProfileInstanceManager profileManager = (ProfileInstanceManager)ctx.getBean(PROFILE_MANAGER, ProfileInstanceManager.class);
        profileManager.setProfile(profile);
        return profileManager;
    }

    @Override
    public void freezeDatabase(String profileId) {
        ApplicationContext ctx = (ApplicationContext)this.profileInstanceManagers.get(profileId);
        DerbyPooledDataSource dataSource = (DerbyPooledDataSource)((Object)ctx.getBean(DATA_SOURCE_BEAN_NAME));
        try {
            dataSource.freeze();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void thawDatabase(String profileId) {
        ApplicationContext ctx = (ApplicationContext)this.profileInstanceManagers.get(profileId);
        DerbyPooledDataSource dataSource = (DerbyPooledDataSource)((Object)ctx.getBean(DATA_SOURCE_BEAN_NAME));
        try {
            dataSource.thaw();
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public Connection getConnection(String profileId) {
        ApplicationContext ctx = (ApplicationContext)this.profileInstanceManagers.get(profileId);
        DerbyPooledDataSource dataSource = (DerbyPooledDataSource)((Object)ctx.getBean(DATA_SOURCE_BEAN_NAME));
        try {
            return dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new ProfileException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized void closeProfileInstance(String location) {
        GenericApplicationContext ctx = this.profileInstanceManagers.remove(location);
        if (ctx != null) {
            ctx.close();
        }
    }

    @Override
    public synchronized ProfileInstanceManager getProfileInstanceManager(String profileId) {
        if (!this.profileInstanceManagers.containsKey(profileId)) {
            throw new IllegalArgumentException(String.format("No profile instance exists [%s]", profileId));
        }
        return (ProfileInstanceManager)this.profileInstanceManagers.get(profileId).getBean(PROFILE_MANAGER);
    }
}

