/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.NodeStatus;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterCriterion;
import uk.gov.nationalarchives.droid.core.interfaces.filter.RestrictionFactory;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Criterion;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Junction;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.QueryBuilder;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Restrictions;
import uk.gov.nationalarchives.droid.profile.NodeMetaData;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;

public final class SqlUtils {
    private static final int NODE_COL_INDEX = 1;
    private static final int EXTENSION_MISMATCH_COL_INDEX = 2;
    private static final int FINISHED_TIMESTAMP_COL_INDEX = 3;
    private static final int EXTENSION_COL_INDEX = 5;
    private static final int HASH_COL_INDEX = 6;
    private static final int IDINT_COL_INDEX = 7;
    private static final int LAST_MOD_COL_INDEX = 8;
    private static final int NAME_COL_INDEX = 9;
    private static final int NODE_STATUS_COL_INDEX = 10;
    private static final int RESOURCE_TYPE_COL_INDEX = 11;
    private static final int SIZE_COL_INDEX = 12;
    private static final int PARENT_ID_COL_INDEX = 13;
    private static final int PREFIX_COL_INDEX = 14;
    private static final int PREFIX_PLUS_ONE_COL_INDEX = 15;
    private static final int URI_COL_INDEX = 17;
    private static final int FILTER_STATUS_COL_INDEX = 20;
    private static final int FORMAT_VERSION_INDEX = 4;
    private static final int FORMAT_NAME_INDEX = 3;
    private static final int FORMAT_MIME_TYPE_INDEX = 2;
    private static final int FORMAT_PUID_INDEX = 1;

    private SqlUtils() {
    }

    public static Object transformParameterToSQLValue(Object value) {
        return value instanceof Enum ? Integer.valueOf(((Enum)value).ordinal()) : value;
    }

    public static String transformEJBtoSQLFields(String ejbFragment, String nodePrefix, String formatPrefix) {
        return ejbFragment.replace("profileResourceNode.metaData.name", nodePrefix + ".u_name ").replace("profileResourceNode.metaData.size", nodePrefix + ".file_size").replace("profileResourceNode.metaData.extensionMismatch", nodePrefix + ".extension_mismatch").replace("profileResourceNode.metaData.extension", nodePrefix + ".u_extension").replace("profileResourceNode.identificationCount", nodePrefix + ".identification_count").replace("profileResourceNode.metaData.lastModifiedDate", nodePrefix + ".last_modified_date").replace("profileResourceNode.metaData.resourceType", nodePrefix + ".resource_type").replace("profileResourceNode.metaData.identificationMethod", nodePrefix + ".identification_method").replace("profileResourceNode.metaData.nodeStatus", nodePrefix + ".node_status").replace("format.mimeType", formatPrefix + ".mime_type").replace("format.name", formatPrefix + ".u_name").replace("format.puid", formatPrefix + ".puid").replace("extensionMismatch", "extension_mismatch");
    }

    public static QueryBuilder getQueryBuilder(Filter filter) {
        QueryBuilder queryBuilder = QueryBuilder.forAlias((String)"profileResourceNode");
        queryBuilder.createAlias("format");
        if (filter.isNarrowed()) {
            for (FilterCriterion criterion : filter.getCriteria()) {
                queryBuilder.add(RestrictionFactory.forFilterCriterion((FilterCriterion)criterion));
            }
        } else {
            Junction disjunction = Restrictions.disjunction();
            for (FilterCriterion criterion : filter.getCriteria()) {
                disjunction.add(RestrictionFactory.forFilterCriterion((FilterCriterion)criterion));
            }
            queryBuilder.add((Criterion)disjunction);
        }
        return queryBuilder;
    }

    public static Format buildFormat(ResultSet results) throws SQLException {
        Format format = new Format();
        format.setPuid(results.getString(1));
        format.setMimeType(SqlUtils.getNullableString(2, results));
        format.setName(SqlUtils.getNullableString(3, results));
        format.setVersion(SqlUtils.getNullableString(4, results));
        return format;
    }

    public static ProfileResourceNode buildProfileResourceNode(ResultSet nodeResults) throws SQLException {
        URI uri;
        Long nodeId = nodeResults.getLong(1);
        Boolean extensionMismatch = nodeResults.getBoolean(2);
        java.util.Date finishedTimestamp = SqlUtils.getNullableTimestamp(3, nodeResults);
        String extension = SqlUtils.getNullableString(5, nodeResults);
        String hash = SqlUtils.getNullableString(6, nodeResults);
        Integer idInt = SqlUtils.getNullableInteger(7, nodeResults);
        IdentificationMethod idMethod = idInt == null ? null : IdentificationMethod.values()[idInt];
        java.util.Date lastModifiedDate = SqlUtils.getNullableTimestamp(8, nodeResults);
        Long lastModifiedTime = lastModifiedDate == null ? null : Long.valueOf(lastModifiedDate.getTime());
        String name = nodeResults.getString(9);
        Integer nodeS = SqlUtils.getNullableInteger(10, nodeResults);
        NodeStatus nodeStatus = nodeS == null ? null : NodeStatus.values()[nodeS];
        Integer rType = SqlUtils.getNullableInteger(11, nodeResults);
        ResourceType resourceType = rType == null ? null : ResourceType.values()[rType];
        Long size = SqlUtils.getNullableLong(12, nodeResults);
        Long parentId = SqlUtils.getNullableLong(13, nodeResults);
        String prefix = SqlUtils.getNullableString(14, nodeResults);
        String prefixPlusOne = SqlUtils.getNullableString(15, nodeResults);
        String uriString = nodeResults.getString(17);
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new SQLException("The URI for the node obtained from the database: [" + uriString + "] could not be converted into a URI", e);
        }
        int filterStatus = 1;
        if (SqlUtils.getNumberOfColumns(nodeResults) > 17) {
            filterStatus = nodeResults.getInt(20);
        }
        ProfileResourceNode node = new ProfileResourceNode(uri);
        NodeMetaData metadata = new NodeMetaData();
        node.setMetaData(metadata);
        node.setId(nodeId);
        node.setExtensionMismatch(extensionMismatch);
        node.setFinished(finishedTimestamp);
        metadata.setExtension(extension);
        metadata.setHash(hash);
        metadata.setIdentificationMethod(idMethod);
        metadata.setLastModified(lastModifiedTime);
        metadata.setName(name);
        metadata.setNodeStatus(nodeStatus);
        metadata.setResourceType(resourceType);
        metadata.setSize(size);
        node.setParentId(parentId);
        node.setPrefix(prefix);
        node.setPrefixPlusOne(prefixPlusOne);
        node.setFilterStatus(filterStatus);
        return node;
    }

    public static int getNumberOfColumns(ResultSet resultSet) throws SQLException {
        ResultSetMetaData rsmd = resultSet.getMetaData();
        return rsmd.getColumnCount();
    }

    public static Integer getNullableInteger(int position, ResultSet results) throws SQLException {
        int value = results.getInt(position);
        return results.wasNull() ? null : Integer.valueOf(value);
    }

    public static Integer getNullableInteger(String column, ResultSet results) throws SQLException {
        int value = results.getInt(column);
        return results.wasNull() ? null : Integer.valueOf(value);
    }

    public static String getNullableString(int position, ResultSet results) throws SQLException {
        String value = results.getString(position);
        return results.wasNull() ? null : value;
    }

    public static String getNullableString(String column, ResultSet results) throws SQLException {
        String value = results.getString(column);
        return results.wasNull() ? null : value;
    }

    public static Long getNullableLong(int position, ResultSet results) throws SQLException {
        Long value = results.getLong(position);
        return results.wasNull() ? null : value;
    }

    public static Long getNullableLong(String column, ResultSet results) throws SQLException {
        Long value = results.getLong(column);
        return results.wasNull() ? null : value;
    }

    public static java.util.Date getNullableTimestamp(int position, ResultSet results) throws SQLException {
        Timestamp value = results.getTimestamp(position);
        return results.wasNull() ? null : value;
    }

    public static java.util.Date getNullableTimestamp(String column, ResultSet results) throws SQLException {
        Timestamp value = results.getTimestamp(column);
        return results.wasNull() ? null : value;
    }

    public static void addIdentifications(ProfileResourceNode node, ResultSet identifications, Map<String, Format> puidFormatMap) throws SQLException {
        while (identifications.next()) {
            node.addFormatIdentification(puidFormatMap.get(identifications.getString(2)));
        }
    }

    public static void setNullableString(int position, String value, PreparedStatement statement) throws SQLException {
        if (value == null) {
            statement.setNull(position, 12);
        } else {
            statement.setString(position, value);
        }
    }

    public static void setNullableInteger(int position, Integer value, PreparedStatement statement) throws SQLException {
        if (value == null) {
            statement.setNull(position, 4);
        } else {
            statement.setInt(position, value);
        }
    }

    public static void setNullableLong(int position, Long value, PreparedStatement statement) throws SQLException {
        if (value == null) {
            statement.setNull(position, -5);
        } else {
            statement.setLong(position, value);
        }
    }

    public static void setNullableTimestamp(int position, java.util.Date value, PreparedStatement statement) throws SQLException {
        if (value == null) {
            statement.setNull(position, 93);
        } else {
            statement.setTimestamp(position, new Timestamp(value.getTime()));
        }
    }

    public static void setNullableEnumAsInt(int position, Enum value, PreparedStatement statement) throws SQLException {
        if (value == null) {
            statement.setNull(position, 4);
        } else {
            statement.setInt(position, value.ordinal());
        }
    }

    public static void setNonNullableParameter(int position, Object parameter, PreparedStatement statement) throws SQLException {
        if (parameter instanceof Integer) {
            statement.setInt(position, (Integer)parameter);
        } else if (parameter instanceof Long) {
            statement.setLong(position, (Long)parameter);
        } else if (parameter instanceof Enum) {
            statement.setInt(position, ((Enum)parameter).ordinal());
        } else if (parameter instanceof java.util.Date) {
            statement.setDate(position, new Date(((java.util.Date)parameter).getTime()));
        } else if (parameter instanceof String) {
            statement.setString(position, (String)parameter);
        } else if (parameter instanceof Boolean) {
            statement.setBoolean(position, (Boolean)parameter);
        }
    }

    public static enum ClassName {
        String,
        Date,
        Long,
        Integer,
        Boolean;

    }
}

