/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyPooledDataSource
extends HikariDataSource {
    private static final long serialVersionUID = -8613139738021279720L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final HikariConfig config;

    public DerbyPooledDataSource(HikariConfig config) {
        super(config);
        this.config = config;
    }

    public void close() {
        this.log.debug(String.format("Closing database [%s]", this.config.getJdbcUrl()));
        super.close();
        String url = this.config.getJdbcUrl() + ";shutdown=true";
        try {
            DriverManager.getConnection(url);
        }
        catch (SQLException e) {
            if ("08006".equals(e.getSQLState())) {
                this.log.debug(e.getMessage());
            }
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void freeze() {
        this.log.debug(String.format("Freezing database [%s]", this.config.getJdbcUrl()));
        try (Statement s = DriverManager.getConnection(this.config.getJdbcUrl()).createStatement();){
            s.executeUpdate("CALL SYSCS_UTIL.SYSCS_FREEZE_DATABASE()");
        }
        catch (SQLException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void thaw() {
        this.log.debug(String.format("Derby thawing database [%s]", this.config.getJdbcUrl()));
        try (Statement s = DriverManager.getConnection(this.config.getJdbcUrl()).createStatement();){
            s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UNFREEZE_DATABASE()");
        }
        catch (SQLException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }
}

