/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.results.handlers;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.ProfileResultObserver;
import uk.gov.nationalarchives.droid.results.handlers.ProgressMonitor;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;

public class ProgressMonitorImpl
implements ProgressMonitor {
    private static final int UNITY_PERCENT = 100;
    private volatile long count;
    private volatile int progressPercentage = -1;
    private long target = -1L;
    private Set<URI> jobsInProgress = Collections.synchronizedSet(new HashSet());
    private ProgressObserver observer;
    private ProfileResultObserver resultObserver;

    public ProgressMonitorImpl() {
    }

    public ProgressMonitorImpl(ProgressObserver observer, ProfileResultObserver resultObserver) {
        this.setPercentIncrementObserver(observer);
        this.setResultObserver(resultObserver);
    }

    @Override
    public long getIdentificationCount() {
        return this.count;
    }

    @Override
    public long getTargetCount() {
        return this.target;
    }

    @Override
    public long getProfileSize() {
        return this.target;
    }

    @Override
    public int getProgressPercentage() {
        return this.progressPercentage;
    }

    synchronized void increment() {
        ++this.count;
        if (this.target == -1L) {
            this.progressPercentage = -1;
        } else {
            this.calcProgress();
        }
    }

    private void calcProgress() {
        if (this.target > 0L) {
            int oldProg = this.progressPercentage;
            int newProg = (int)(100L * this.count / this.target);
            if (newProg > 100) {
                newProg = 100;
            }
            this.progressPercentage = newProg;
            if (this.observer != null && newProg != oldProg) {
                this.observer.onProgress(this.progressPercentage);
            }
        }
    }

    @Override
    public synchronized void setTargetCount(long targetCount) {
        this.target = targetCount;
        this.calcProgress();
    }

    @Override
    public void setPercentIncrementObserver(ProgressObserver progressObserver) {
        this.observer = progressObserver;
    }

    @Override
    public void startJob(URI uri) {
        this.jobsInProgress.add(uri);
    }

    @Override
    public void stopJob(ProfileResourceNode node) {
        if (this.jobsInProgress.remove(node.getUri())) {
            this.increment();
        }
        if (this.resultObserver != null) {
            this.resultObserver.onResult(node);
        }
    }

    @Override
    public void setResultObserver(ProfileResultObserver resultObserver) {
        this.resultObserver = resultObserver;
    }

    @Override
    public void initialise(long targetCount, long currentCount) {
        this.target = targetCount;
        this.count = currentCount;
        this.calcProgress();
    }
}

