/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.signature;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Element;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;
import uk.gov.nationalarchives.droid.core.interfaces.signature.ProxySettings;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureServiceException;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureType;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureUpdateService;
import uk.gov.nationalarchives.pronom.PronomService;
import uk.gov.nationalarchives.pronom.Version;

public class PronomSignatureService
implements SignatureUpdateService {
    private PronomService pronomService;
    private String filenamePattern;

    public PronomSignatureService() {
    }

    public PronomSignatureService(PronomService pronomService, String filenamePattern) {
        this.setPronomService(pronomService);
        this.setFilenamePattern(filenamePattern);
    }

    public SignatureFileInfo importSignatureFile(Path targetDir) throws SignatureServiceException {
        Element sigFile = this.pronomService.getSignatureFileV1().getElement();
        int version = Integer.valueOf(sigFile.getAttribute("Version"));
        boolean deprecated = Boolean.valueOf(sigFile.getAttribute("Deprecated"));
        SignatureFileInfo sigInfo = new SignatureFileInfo(version, deprecated, SignatureType.BINARY);
        String fileName = String.format(this.filenamePattern, version);
        Path outputFile = targetDir.resolve(fileName);
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            XMLSerializer serializer = new XMLSerializer((Writer)writer, new OutputFormat("xml", "UTF-8", true));
            serializer.serialize(sigFile);
            sigInfo.setFile(outputFile);
        }
        catch (IOException e) {
            throw new SignatureServiceException((Throwable)e);
        }
        return sigInfo;
    }

    public void setPronomService(PronomService pronomService) {
        this.pronomService = pronomService;
    }

    public void setFilenamePattern(String filenamePattern) {
        this.filenamePattern = filenamePattern;
    }

    public SignatureFileInfo getLatestVersion(int currentVersion) {
        Holder version = new Holder();
        Holder deprecated = new Holder();
        this.pronomService.getSignatureFileVersionV1((Holder<Version>)version, (Holder<Boolean>)deprecated);
        SignatureFileInfo info = new SignatureFileInfo(((Version)version.value).getVersion(), ((Boolean)deprecated.value).booleanValue(), SignatureType.BINARY);
        return info;
    }

    void setEndpointUrl(String url) {
        ((BindingProvider)this.pronomService).getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
    }

    public void configurationChanged(ConfigurationEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals(DroidGlobalProperty.BINARY_UPDATE_URL.getName())) {
            this.setEndpointUrl((String)evt.getPropertyValue());
        }
    }

    public void onProxyChange(ProxySettings proxySettings) {
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnection(ConnectionType.CLOSE);
        httpClientPolicy.setAllowChunking(true);
        httpClientPolicy.setCacheControl("no-cache");
        if (proxySettings.isEnabled()) {
            httpClientPolicy.setProxyServer(proxySettings.getProxyHost());
            httpClientPolicy.setProxyServerPort(Integer.valueOf(proxySettings.getProxyPort()));
            httpClientPolicy.setProxyServerType(ProxyServerType.HTTP);
        } else {
            httpClientPolicy.setProxyServer(null);
            httpClientPolicy.setProxyServerPort(null);
            httpClientPolicy.setProxyServerType(null);
        }
        Client client = ClientProxy.getClient((Object)this.pronomService);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        http.setClient(httpClientPolicy);
    }

    public void init(DroidGlobalConfig config) {
        this.setEndpointUrl(config.getProperties().getString(DroidGlobalProperty.BINARY_UPDATE_URL.getName()));
    }
}

