/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.util.FileUtil;

public class DirectoryEventHandler {
    private static final int URI_STRING_BUILDER_CAPACITY = 1024;
    private ResultHandler resultHandler;
    private StringBuilder uriStringBuilder = new StringBuilder(1024);

    public DirectoryEventHandler() {
    }

    public DirectoryEventHandler(ResultHandler resultHandler) {
        this.setResultHandler(resultHandler);
    }

    public ResourceId onEvent(Path dir, ResourceId parentId, int depth, boolean restricted) {
        IdentificationResultImpl result = new IdentificationResultImpl();
        result.setMethod(IdentificationMethod.NULL);
        FileTime lastModified = FileUtil.lastModifiedQuietly(dir);
        RequestMetaData metaData = new RequestMetaData(Long.valueOf(-1L), Long.valueOf(lastModified == null ? new Date(0L).getTime() : new Date(lastModified.toMillis()).getTime()), depth == 0 ? dir.toAbsolutePath().toString() : FileUtil.fileName(dir));
        RequestIdentifier identifier = new RequestIdentifier(dir.toUri());
        identifier.setParentResourceId(parentId);
        result.setRequestMetaData(metaData);
        result.setIdentifier(identifier);
        return this.resultHandler.handleDirectory((IdentificationResult)result, parentId, restricted);
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }
}

