/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.commons.io.DirectoryWalker;
import uk.gov.nationalarchives.droid.profile.AbstractProfileResource;
import uk.gov.nationalarchives.droid.profile.ProfileSpec;

public class ProfileSpecJobCounter
implements Callable<Long> {
    public static final int PROGRESS_DEPTH_LIMIT = 4;
    private ProfileSpec profileSpec;
    private long count;
    private volatile boolean cancelled;

    public ProfileSpecJobCounter(ProfileSpec profileSpec) {
        this.profileSpec = profileSpec;
    }

    @Override
    public Long call() throws IOException {
        for (AbstractProfileResource resource : this.profileSpec.getResources()) {
            if (this.cancelled) break;
            if (resource.isDirectory()) {
                LukeFileWalker walker = new LukeFileWalker(resource.getUri(), resource.isRecursive());
                walker.walk();
                continue;
            }
            ++this.count;
        }
        return this.count;
    }

    public void cancel() {
        this.cancelled = true;
    }

    private final class LukeFileWalker
    extends DirectoryWalker {
        private File root;
        private boolean recursive;

        public LukeFileWalker(URI root, boolean recursive) {
            super(null, recursive ? 4 : 1);
            this.recursive = recursive;
            this.root = Paths.get(root).toFile();
        }

        public void walk() throws IOException {
            super.walk(this.root, null);
        }

        protected void handleFile(File file, int depth, Collection results) {
            ProfileSpecJobCounter.this.count++;
        }

        protected boolean handleDirectory(File directory, int depth, Collection results) {
            ProfileSpecJobCounter.this.count++;
            return this.recursive || depth == 0;
        }

        protected boolean handleIsCancelled(File file, int depth, Collection results) {
            return ProfileSpecJobCounter.this.cancelled;
        }
    }
}

