/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.profile.AbstractProfileResource;
import uk.gov.nationalarchives.droid.profile.ProfileSpec;
import uk.gov.nationalarchives.droid.results.handlers.ProgressMonitor;
import uk.gov.nationalarchives.droid.submitter.DirectoryEventHandler;
import uk.gov.nationalarchives.droid.submitter.FileEventHandler;
import uk.gov.nationalarchives.droid.submitter.FileWalker;
import uk.gov.nationalarchives.droid.submitter.FileWalkerHandler;
import uk.gov.nationalarchives.droid.submitter.ProfileSpecWalker;
import uk.gov.nationalarchives.droid.submitter.ProfileWalkState;
import uk.gov.nationalarchives.droid.submitter.SubmitterUtils;

public class ProfileSpecWalkerImpl
implements ProfileSpecWalker {
    private static final int URI_BUILDER_SIZE = 1204;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private FileEventHandler fileEventHandler;
    private DirectoryEventHandler directoryEventHandler;
    private ProgressMonitor progressMonitor;
    private volatile transient boolean cancelled;
    private StringBuilder uriBuilder = new StringBuilder(1204);

    public ProfileSpecWalkerImpl() {
    }

    public ProfileSpecWalkerImpl(FileEventHandler fileEventHandler, DirectoryEventHandler directoryEventHandler, ProgressMonitor progressMonitor) {
        this.setFileEventHandler(fileEventHandler);
        this.setDirectoryEventHandler(directoryEventHandler);
        this.setProgressMonitor(progressMonitor);
    }

    @Override
    public void walk(ProfileSpec profileSpec, ProfileWalkState walkState) throws IOException {
        List<AbstractProfileResource> resources = profileSpec.getResources();
        boolean fastForward = false;
        int startIndex = 0;
        if (walkState.getWalkStatus().equals((Object)ProfileWalkState.WalkStatus.IN_PROGRESS)) {
            fastForward = true;
            startIndex = resources.indexOf(walkState.getCurrentResource());
        }
        for (int i = startIndex; i < resources.size(); ++i) {
            AbstractProfileResource resource = resources.get(i);
            if (!fastForward) {
                walkState.setCurrentResource(resource);
                walkState.setCurrentFileWalker(null);
            }
            if (this.cancelled) break;
            if (resource.isDirectory()) {
                if (!fastForward) {
                    walkState.setCurrentFileWalker(new FileWalker(resource.getUri(), resource.isRecursive()));
                }
                FileWalker fileWalker = walkState.getCurrentFileWalker();
                fileWalker.setFileHandler(new FileWalkerHandler(){

                    @Override
                    public ResourceId handle(Path file, int depth, FileWalker.ProgressEntry parent) {
                        if (depth <= 4) {
                            ProfileSpecWalkerImpl.this.progressMonitor.startJob(ProfileSpecWalkerImpl.this.toURI(file));
                        }
                        ResourceId parentId = parent == null ? null : parent.getResourceId();
                        ProfileSpecWalkerImpl.this.fileEventHandler.onEvent(file, parentId, null);
                        return null;
                    }
                });
                fileWalker.setDirectoryHandler(new FileWalkerHandler(){

                    @Override
                    public ResourceId handle(Path file, int depth, FileWalker.ProgressEntry parent) {
                        if (depth <= 4) {
                            ProfileSpecWalkerImpl.this.progressMonitor.startJob(ProfileSpecWalkerImpl.this.toURI(file));
                        }
                        ResourceId parentId = parent == null ? null : parent.getResourceId();
                        return ProfileSpecWalkerImpl.this.directoryEventHandler.onEvent(file, parentId, depth, false);
                    }
                });
                fileWalker.setRestrictedDirectoryHandler(new FileWalkerHandler(){

                    @Override
                    public ResourceId handle(Path file, int depth, FileWalker.ProgressEntry parent) {
                        if (depth <= 4) {
                            ProfileSpecWalkerImpl.this.progressMonitor.startJob(ProfileSpecWalkerImpl.this.toURI(file));
                        }
                        ResourceId parentId = parent == null ? null : parent.getResourceId();
                        return ProfileSpecWalkerImpl.this.directoryEventHandler.onEvent(file, parentId, depth, true);
                    }
                });
                walkState.setWalkStatus(ProfileWalkState.WalkStatus.IN_PROGRESS);
                fileWalker.walk();
            } else {
                this.progressMonitor.startJob(resource.getUri());
                this.fileEventHandler.onEvent(Paths.get(resource.getUri()), null, null);
            }
            fastForward = false;
        }
        walkState.setWalkStatus(ProfileWalkState.WalkStatus.FINISHED);
        this.progressMonitor.setTargetCount(this.progressMonitor.getIdentificationCount());
    }

    public void setFileEventHandler(FileEventHandler fileEventHandler) {
        this.fileEventHandler = fileEventHandler;
    }

    public void setDirectoryEventHandler(DirectoryEventHandler directoryEventHandler) {
        this.directoryEventHandler = directoryEventHandler;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    @Override
    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    @Override
    public FileEventHandler getFileEventHandler() {
        return this.fileEventHandler;
    }

    private URI toURI(Path file) {
        return SubmitterUtils.toURI(file.toFile(), this.uriBuilder);
    }
}

