/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.results.handlers.ResultHandlerDao;
import uk.gov.nationalarchives.droid.submitter.FileEventHandler;
import uk.gov.nationalarchives.droid.submitter.SubmissionQueue;
import uk.gov.nationalarchives.droid.submitter.SubmissionQueueData;

public class ReplaySubmitter {
    private static final int FIVE = 5;
    private FileEventHandler fileEventHandler;
    private SubmissionQueue submissionQueue;
    private ResultHandlerDao resultHandlerDao;

    public ReplaySubmitter() {
    }

    public ReplaySubmitter(FileEventHandler fileEventHandler, SubmissionQueue submissionQueue, ResultHandlerDao resultHandler) {
        this.setFileEventHandler(fileEventHandler);
        this.setSubmissionQueue(submissionQueue);
        this.setResultHandlerDao(resultHandler);
    }

    public void replay() {
        SubmissionQueueData queueData = this.submissionQueue.list();
        if (queueData != null) {
            HashSet<Long> ancestorIds = new HashSet<Long>();
            List<RequestIdentifier> identifiers = queueData.getReplayUris();
            for (RequestIdentifier identifier : identifiers) {
                ancestorIds.add(identifier.getAncestorId());
            }
            for (Long ancestorId : ancestorIds) {
                ProfileResourceNode node = this.resultHandlerDao.loadNode(ancestorId);
                ResourceId parentId = this.getParentResourceId(node);
                this.resultHandlerDao.deleteNode(node.getId());
                Path file = Paths.get(node.getUri());
                this.fileEventHandler.onEvent(file, parentId, null);
            }
        }
    }

    private ResourceId getParentResourceId(ProfileResourceNode node) {
        ResourceId id = null;
        Long parentId = node.getParentId();
        if (parentId != null) {
            String parentPrefix = node.getPrefix();
            parentPrefix = parentPrefix.length() >= 5 ? parentPrefix.substring(0, parentPrefix.length() - 5) : "";
            id = new ResourceId(parentId.longValue(), parentPrefix);
        }
        return id;
    }

    public void setFileEventHandler(FileEventHandler fileEventHandler) {
        this.fileEventHandler = fileEventHandler;
    }

    public void setSubmissionQueue(SubmissionQueue submissionQueue) {
        this.submissionQueue = submissionQueue;
    }

    public void setResultHandlerDao(ResultHandlerDao resultHandlerDao) {
        this.resultHandlerDao = resultHandlerDao;
    }
}

