/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.DroidCore;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationErrorType;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationException;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFormatResolver;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandlerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ContainerIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ContainerIdentifierFactory;
import uk.gov.nationalarchives.droid.core.interfaces.control.PauseAspect;
import uk.gov.nationalarchives.droid.core.interfaces.hash.HashGenerator;
import uk.gov.nationalarchives.droid.submitter.JobCounter;
import uk.gov.nationalarchives.droid.submitter.ReplaySubmitter;
import uk.gov.nationalarchives.droid.submitter.SubmissionQueue;

public class SubmissionGateway
implements AsynchDroid {
    private static final String CONTAINER_ERROR = "Could not process the potential container format (%s): %s\t%s\t%s";
    private static final String ARCHIVE_ERROR = "Could not process the archival format(%s): %s\t%s\t%s";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final JobCounter jobCounter = new JobCounter();
    private DroidCore droidCore;
    private ResultHandler resultHandler;
    private ExecutorService executorService;
    private boolean processZip;
    private boolean processTar;
    private boolean processGzip;
    private boolean processRar;
    private boolean process7zip;
    private boolean processIso;
    private boolean processBzip2;
    private boolean processArc;
    private boolean processWarc;
    private ArchiveFormatResolver archiveFormatResolver;
    private ArchiveFormatResolver containerFormatResolver;
    private ArchiveHandlerFactory archiveHandlerFactory;
    private ContainerIdentifierFactory containerIdentifierFactory;
    private HashGenerator hashGenerator;
    private String hashAlgorithm;
    private boolean generateHash;
    private boolean matchAllExtensions;
    private long maxBytesToScan = -1L;
    private SubmissionQueue submissionQueue;
    private ReplaySubmitter replaySubmitter;
    private PauseAspect pauseControl;
    private Set<IdentificationRequest> requests = Collections.synchronizedSet(new HashSet());

    public SubmissionGateway() {
    }

    public SubmissionGateway(DroidCore droidCore, ResultHandler resultHandler, ExecutorService executorService, ArchiveFormatResolver archiveFormatResolver, ArchiveFormatResolver containerFormatResolver, ArchiveHandlerFactory archiveHandlerFactory, ContainerIdentifierFactory containerFactory, PauseAspect pauseControl, ReplaySubmitter replaySubmitter, long maxBytesToScan) {
        this.setDroidCore(droidCore);
        this.setResultHandler(resultHandler);
        this.setExecutorService(executorService);
        this.setArchiveFormatResolver(archiveFormatResolver);
        this.setContainerFormatResolver(containerFormatResolver);
        this.setArchiveHandlerFactory(archiveHandlerFactory);
        this.setContainerIdentifierFactory(containerFactory);
        this.setPauseAspect(pauseControl);
        this.setReplaySubmitter(replaySubmitter);
        this.setMaxBytesToScan(maxBytesToScan);
        this.setProcess7zip(this.processZip);
        this.setProcessTar(this.processTar);
        this.setProcessGzip(this.processGzip);
        this.setProcessRar(this.processRar);
        this.setProcess7zip(this.process7zip);
        this.setProcessIso(this.processIso);
        this.setProcessBzip2(this.processBzip2);
        this.setProcessArc(this.processArc);
        this.setProcessWarc(this.processWarc);
        this.setMatchAllExtensions(this.matchAllExtensions);
        this.setGenerateHash(this.generateHash);
    }

    public Future<IdentificationResultCollection> submit(final IdentificationRequest request) {
        this.pauseControl.awaitUnpaused();
        this.jobCounter.increment();
        this.requests.add(request);
        Callable<IdentificationResultCollection> callable = new Callable<IdentificationResultCollection>(){

            @Override
            public IdentificationResultCollection call() throws IOException {
                SubmissionGateway.this.droidCore.setMaxBytesToScan(SubmissionGateway.this.maxBytesToScan);
                IdentificationResultCollection results = SubmissionGateway.this.droidCore.matchBinarySignatures(request);
                return results;
            }
        };
        SubmissionFutureTask task = new SubmissionFutureTask(callable, request);
        this.executorService.submit(task);
        return task;
    }

    public void replay() {
        this.replaySubmitter.replay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHash(IdentificationRequest request) throws IOException {
        if (this.generateHash) {
            try (InputStream in = request.getSourceInputStream();){
                String hash = this.hashGenerator.hash(in);
                request.getRequestMetaData().setHash(hash);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private IdentificationResultCollection handleExtensions(IdentificationRequest request, IdentificationResultCollection results) {
        IdentificationResultCollection extensionResults = results;
        try {
            List resultList = results.getResults();
            if (resultList != null && resultList.isEmpty()) {
                IdentificationResultCollection checkExtensionResults = this.droidCore.matchExtensions(request, this.matchAllExtensions);
                if (checkExtensionResults != null) {
                    extensionResults = checkExtensionResults;
                }
            } else {
                this.droidCore.checkForExtensionsMismatches(extensionResults, request.getExtension());
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return extensionResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleArchive(IdentificationRequest request, IdentificationResultCollection results, String archiveFormat) {
        results.setArchive(true);
        ResourceId id = this.resultHandler.handle(results);
        this.jobCounter.incrementPostProcess();
        RequestIdentifier identifier = request.getIdentifier();
        identifier.setResourceId(id);
        if (identifier.getAncestorId() == null) {
            identifier.setAncestorId(Long.valueOf(id.getId()));
        }
        this.submissionQueue.add(request.getIdentifier());
        this.jobCounter.decrement();
        try {
            ArchiveHandler handler = this.archiveHandlerFactory.getHandler(archiveFormat);
            handler.handle(request);
        }
        catch (Exception e) {
            String causeMessage = "";
            if (e.getCause() != null) {
                causeMessage = e.getCause().getMessage();
            }
            String message = String.format(ARCHIVE_ERROR, archiveFormat, request.getIdentifier().getUri().toString(), e.getMessage(), causeMessage);
            if (this.log.isDebugEnabled()) {
                this.log.debug(message, (Throwable)e);
            } else {
                this.log.warn(message);
            }
            this.resultHandler.handleError(new IdentificationException(request, IdentificationErrorType.OTHER, (Throwable)e));
        }
        finally {
            this.submissionQueue.remove(request.getIdentifier());
            this.jobCounter.decrementPostProcess();
        }
    }

    private IdentificationResultCollection handleContainer(IdentificationRequest request, IdentificationResultCollection results) throws IOException {
        String containerFormat = this.getContainerFormat(results);
        try {
            if (this.containerFormatResolver != null && containerFormat != null) {
                ContainerIdentifier containerIdentifier = this.containerIdentifierFactory.getIdentifier(containerFormat);
                containerIdentifier.setMaxBytesToScan(this.maxBytesToScan);
                IdentificationResultCollection containerResults = containerIdentifier.submit(request);
                this.droidCore.removeLowerPriorityHits(containerResults);
                this.droidCore.checkForExtensionsMismatches(containerResults, request.getExtension());
                containerResults.setFileLength(Long.valueOf(request.size()));
                containerResults.setRequestMetaData(request.getRequestMetaData());
                return containerResults.getResults().isEmpty() ? null : containerResults;
            }
        }
        catch (Exception e) {
            String causeMessage = "";
            if (e.getCause() != null) {
                causeMessage = e.getCause().getMessage();
            }
            String message = String.format(CONTAINER_ERROR, containerFormat, request.getIdentifier().getUri().toString(), e.getMessage(), causeMessage);
            this.log.warn(message);
        }
        return null;
    }

    private String getArchiveFormat(IdentificationResultCollection results) {
        List theResults = results.getResults();
        int numResults = theResults.size();
        for (int i = 0; i < numResults; ++i) {
            IdentificationResult result = (IdentificationResult)theResults.get(i);
            String format = this.archiveFormatResolver.forPuid(result.getPuid());
            if (format == null) continue;
            if (this.isProcessedArchiveOrWebArchiveFormat(format)) {
                format = null;
            }
            return format;
        }
        return null;
    }

    private boolean isProcessedArchiveOrWebArchiveFormat(String format) {
        return "ZIP".equals(format) && !this.processZip || "TAR".equals(format) && !this.processTar || "GZ".equals(format) && !this.processGzip || "RAR".equals(format) && !this.processRar || "7Z".equals(format) && !this.process7zip || "ISO".equals(format) && !this.processIso || "BZ".equals(format) && !this.processBzip2 || "ARC".equals(format) && !this.processArc || "WARC".equals(format) && !this.processWarc;
    }

    private String getContainerFormat(IdentificationResultCollection results) {
        List theResults = results.getResults();
        int numResults = theResults.size();
        for (int i = 0; i < numResults; ++i) {
            IdentificationResult result = (IdentificationResult)theResults.get(i);
            String format = this.containerFormatResolver.forPuid(result.getPuid());
            if (format == null) continue;
            return format;
        }
        return null;
    }

    public void awaitIdle() throws InterruptedException {
        this.jobCounter.awaitIdle();
    }

    public void awaitFinished() throws InterruptedException {
        this.jobCounter.awaitFinished();
    }

    public void setArchiveFormatResolver(ArchiveFormatResolver archiveFormatResolver) {
        this.archiveFormatResolver = archiveFormatResolver;
    }

    public void setArchiveHandlerFactory(ArchiveHandlerFactory archiveHandlerFactory) {
        this.archiveHandlerFactory = archiveHandlerFactory;
    }

    public void setContainerFormatResolver(ArchiveFormatResolver containerFormatResolver) {
        this.containerFormatResolver = containerFormatResolver;
    }

    public void setContainerIdentifierFactory(ContainerIdentifierFactory containerIdentifierFactory) {
        this.containerIdentifierFactory = containerIdentifierFactory;
    }

    public void setDroidCore(DroidCore droidCore) {
        this.droidCore = droidCore;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setProcessZip(boolean processZip) {
        this.processZip = processZip;
    }

    public void setProcessTar(boolean processTar) {
        this.processTar = processTar;
    }

    public void setProcessGzip(boolean processGzip) {
        this.processGzip = processGzip;
    }

    public void setProcessRar(boolean processRar) {
        this.processRar = processRar;
    }

    public void setProcess7zip(boolean process7zip) {
        this.process7zip = process7zip;
    }

    public void setProcessIso(boolean processIso) {
        this.processIso = processIso;
    }

    public void setProcessBzip2(boolean processBzip2) {
        this.processBzip2 = processBzip2;
    }

    public void setProcessArc(boolean processArc) {
        this.processArc = processArc;
    }

    public void setProcessWarc(boolean processWarc) {
        this.processWarc = processWarc;
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public void setSubmissionQueue(SubmissionQueue submissionQueue) {
        this.submissionQueue = submissionQueue;
    }

    public void save() {
        this.resultHandler.commit();
        this.submissionQueue.save();
    }

    public void setReplaySubmitter(ReplaySubmitter replaySubmitter) {
        this.replaySubmitter = replaySubmitter;
    }

    public void setPauseAspect(PauseAspect pauseAspect) {
        this.pauseControl = pauseAspect;
    }

    public void setHashGenerator(HashGenerator hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    public void setGenerateHash(boolean generateHash) {
        this.generateHash = generateHash;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public void close() throws IOException {
        this.executorService.shutdownNow();
        for (IdentificationRequest request : this.requests) {
            request.close();
        }
    }

    public void setMaxBytesToScan(long maxBytesToScan) {
        this.maxBytesToScan = maxBytesToScan;
    }

    public void setMatchAllExtensions(boolean matchAllExtensions) {
        this.matchAllExtensions = matchAllExtensions;
    }

    private final class SubmissionFutureTask
    extends FutureTask<IdentificationResultCollection> {
        private IdentificationRequest request;

        SubmissionFutureTask(Callable<IdentificationResultCollection> callable, IdentificationRequest request) {
            super(callable);
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            boolean jobCountDecremented = false;
            try {
                SubmissionGateway.this.generateHash(this.request);
                IdentificationResultCollection results = (IdentificationResultCollection)this.get();
                IdentificationResultCollection containerResults = SubmissionGateway.this.handleContainer(this.request, results);
                if (containerResults == null) {
                    SubmissionGateway.this.droidCore.removeLowerPriorityHits(results);
                    results = SubmissionGateway.this.handleExtensions(this.request, results);
                    String archiveFormat = null;
                    if (SubmissionGateway.this.archiveFormatResolver != null) {
                        archiveFormat = SubmissionGateway.this.getArchiveFormat(results);
                    }
                    if (archiveFormat != null) {
                        SubmissionGateway.this.handleArchive(this.request, results, archiveFormat);
                        jobCountDecremented = true;
                    } else {
                        results.setArchive(SubmissionGateway.this.getArchiveFormat(results) != null);
                        ResourceId id = SubmissionGateway.this.resultHandler.handle(results);
                        this.request.getIdentifier().setResourceId(id);
                    }
                } else {
                    SubmissionGateway.this.droidCore.removeLowerPriorityHits(containerResults);
                    containerResults = SubmissionGateway.this.handleExtensions(this.request, containerResults);
                    ResourceId id = SubmissionGateway.this.resultHandler.handle(containerResults);
                    this.request.getIdentifier().setResourceId(id);
                }
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                SubmissionGateway.this.log.error(cause.getStackTrace().toString(), cause);
                SubmissionGateway.this.resultHandler.handleError(new IdentificationException(this.request, IdentificationErrorType.OTHER, cause));
            }
            catch (InterruptedException e) {
                SubmissionGateway.this.log.debug(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                SubmissionGateway.this.resultHandler.handleError(new IdentificationException(this.request, IdentificationErrorType.OTHER, (Throwable)e));
            }
            finally {
                this.closeRequest();
                if (!jobCountDecremented) {
                    SubmissionGateway.this.jobCounter.decrement();
                }
            }
        }

        private void closeRequest() {
            SubmissionGateway.this.requests.remove(this.request);
            try {
                this.request.close();
            }
            catch (IOException e) {
                SubmissionGateway.this.log.error(String.format("Error closing request [%s]", this.request.getIdentifier().getUri()), (Throwable)e);
            }
        }
    }
}

