/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.util;

import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class FileUtil {
    private static final int BYTES_IN_KILOBYTE = 1024;
    private static final SimpleFileVisitor<Path> DELETE_DIR_VISITOR = new DeleteDirVisitor();

    private FileUtil() {
    }

    public static boolean isSymbolicLink(Path file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        return Files.isSymbolicLink(file);
    }

    public static String formatFileSize(long fileSize, int decimalPos) {
        double size;
        double val;
        NumberFormat fmt = NumberFormat.getNumberInstance();
        if (decimalPos >= 0) {
            fmt.setMaximumFractionDigits(decimalPos);
        }
        String formattedSize = (val = (size = (double)fileSize) / 1.073741824E9) > 1.0 ? fmt.format(val).concat(" GB") : ((val = size / 1048576.0) > 1.0 ? fmt.format(val).concat(" MB") : ((val = size / 1024.0) > 1.0 ? fmt.format(val).concat(" KB") : fmt.format(size).concat(" bytes")));
        return formattedSize;
    }

    public static String fileName(Path path) {
        return path.getFileName().toString();
    }

    public static FileTime lastModifiedQuietly(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static long sizeQuietly(Path path) {
        long size = -1L;
        try {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                size = Files.size(path);
            } else {
                DirSizeVisitor dirSizeVisitor = new DirSizeVisitor();
                Files.walkFileTree(path, dirSizeVisitor);
                size = dirSizeVisitor.totalSize();
            }
        }
        catch (IOException ioe) {
            size = -1L;
        }
        return size;
    }

    public static boolean deleteQuietly(Path path) {
        boolean result;
        try {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                result = Files.deleteIfExists(path);
            } else {
                Files.walkFileTree(path, DELETE_DIR_VISITOR);
            }
            result = true;
        }
        catch (IOException ioe) {
            result = false;
        }
        return result;
    }

    public static boolean mkdirsQuietly(Path dir) {
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static List<Path> listFilesQuietly(Path path, boolean recursive, FileFilter fileFilter) {
        try {
            return FileUtil.listFiles(path, recursive, fileFilter);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static List<Path> listFiles(Path path, boolean recursive, FileFilter fileFilter) throws IOException {
        ArrayList<Path> results = new ArrayList<Path>();
        FileUtil.listFiles(path, recursive, FileUtil.asDirFilter(fileFilter), results);
        return results;
    }

    public static List<Path> listFilesQuietly(Path path, boolean recursive, DirectoryStream.Filter<Path> filter) {
        try {
            return FileUtil.listFiles(path, recursive, filter);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static List<Path> listFiles(Path path, boolean recursive, DirectoryStream.Filter<Path> filter) throws IOException {
        ArrayList<Path> results = new ArrayList<Path>();
        FileUtil.listFiles(path, recursive, filter, results);
        return results;
    }

    private static DirectoryStream.Filter<Path> asDirFilter(final FileFilter fileFilter) {
        if (fileFilter == null) {
            return null;
        }
        return new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return fileFilter.accept(entry.toFile());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void listFiles(Path path, boolean recursive, DirectoryStream.Filter<Path> filter, List<Path> results) throws IOException {
        try (DirectoryStream<Path> dirStream = null;){
            dirStream = filter == null ? Files.newDirectoryStream(path) : Files.newDirectoryStream(path, filter);
            for (Path child : dirStream) {
                if (recursive && Files.isDirectory(child, new LinkOption[0])) {
                    FileUtil.listFiles(child, recursive, filter, results);
                    continue;
                }
                results.add(child);
            }
        }
    }

    private static class DeleteDirVisitor
    extends SimpleFileVisitor<Path> {
        private DeleteDirVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.deleteIfExists(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc != null) {
                throw exc;
            }
            Files.deleteIfExists(dir);
            return FileVisitResult.CONTINUE;
        }
    }

    private static class DirSizeVisitor
    extends SimpleFileVisitor<Path> {
        private long size;

        private DirSizeVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.size += Files.size(file);
            return FileVisitResult.CONTINUE;
        }

        public long totalSize() {
            return this.size;
        }
    }
}

