/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.lang.SystemUtils;
import sun.awt.shell.ShellFolder;

public class FileSystemSelectionValidator {
    private final boolean isValid;
    private String errorMessage = "";
    private String errorTemplate = "The following folders cannot be added as they are not from the file system: ";

    public FileSystemSelectionValidator(List<File> files) {
        boolean valid = true;
        if (SystemUtils.IS_OS_WINDOWS) {
            List nonFSFiles = files.stream().filter(item -> !FileSystemView.getFileSystemView().isFileSystem((File)item)).collect(Collectors.toList());
            if (nonFSFiles.size() == 0) {
                valid = true;
            } else {
                this.errorMessage = this.errorTemplate + nonFSFiles.stream().map(item -> ((ShellFolder)item).getDisplayName()).collect(Collectors.joining(","));
                valid = false;
            }
        }
        this.isValid = valid;
    }

    public boolean isSelectionValid() {
        return this.isValid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

