/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.openide.util.NbBundle;
import uk.gov.nationalarchives.droid.gui.DialogUtils;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;

public class MultiIdentificationDialog
extends JDialog {
    private DefaultTableModel dataModel;
    private ProfileForm profileForm;
    private JButton closeButton;
    private JLabel headerLabel;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JLabel nodeName;

    public MultiIdentificationDialog(ProfileForm parent) {
        this.profileForm = parent;
        this.setModal(true);
        this.initComponents();
        PuidLinkMouseListener mouseAdapter = new PuidLinkMouseListener();
        this.jTable1.addMouseMotionListener(mouseAdapter);
        this.jTable1.addMouseListener(mouseAdapter);
    }

    private void initComponents() {
        this.headerLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.closeButton = new JButton();
        this.nodeName = new JLabel();
        this.setTitle(NbBundle.getMessage(MultiIdentificationDialog.class, (String)"MultiIdentificationDialog.title"));
        this.setAlwaysOnTop(true);
        this.headerLabel.setLabelFor(this.jTable1);
        this.headerLabel.setText(NbBundle.getMessage(MultiIdentificationDialog.class, (String)"MultiIdentificationDialog.headerLabel.text"));
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.closeButton.setText(NbBundle.getMessage(MultiIdentificationDialog.class, (String)"MultiIdentificationDialog.closeButton.text"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiIdentificationDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.nodeName.setText(NbBundle.getMessage(MultiIdentificationDialog.class, (String)"MultiIdentificationDialog.nodeName.text"));
        this.nodeName.setMinimumSize(new Dimension(14, 14));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 375, Short.MAX_VALUE).addComponent(this.closeButton, GroupLayout.Alignment.TRAILING, -2, 75, -2).addComponent(this.headerLabel, -1, 375, Short.MAX_VALUE).addComponent(this.nodeName, GroupLayout.Alignment.TRAILING, -1, 375, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.headerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nodeName, -2, -1, -2).addGap(11, 11, 11).addComponent(this.jScrollPane1, -1, 131, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.closeButton).addContainerGap()));
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public void showDialog(ProfileResourceNode node) {
        this.headerLabel.setText(String.format("%s Format Identifications for", node.getFormatIdentifications().size()));
        this.nodeName.setText(URLDecoder.decode(node.getUri().toString()));
        this.newDataModel(node.getFormatIdentifications());
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void newDataModel(List<Format> identifications) {
        String puidColumn = "PUID";
        this.dataModel = new DefaultTableModel(new Object[]{puidColumn, "Format", "Version", "MIME type"}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        for (Format format : identifications) {
            this.dataModel.addRow(new Object[]{format.getPuid(), format.getName(), format.getVersion(), format.getMimeType()});
        }
        this.jTable1.setModel(this.dataModel);
        this.jTable1.getColumn(puidColumn).setCellRenderer(new PuidRenderer());
    }

    private class PuidLinkMouseListener
    extends MouseAdapter {
        private PuidLinkMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point point = e.getPoint();
            int pointedColumn = MultiIdentificationDialog.this.jTable1.columnAtPoint(point);
            if (MultiIdentificationDialog.this.jTable1.convertColumnIndexToModel(pointedColumn) == 0) {
                MultiIdentificationDialog.this.jTable1.setCursor(new Cursor(12));
            } else {
                MultiIdentificationDialog.this.jTable1.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Point point = event.getPoint();
            int pointedColumn = MultiIdentificationDialog.this.jTable1.columnAtPoint(point);
            if (MultiIdentificationDialog.this.jTable1.convertColumnIndexToModel(pointedColumn) == 0) {
                String puid = (String)MultiIdentificationDialog.this.jTable1.getValueAt(MultiIdentificationDialog.this.jTable1.rowAtPoint(point), MultiIdentificationDialog.this.jTable1.columnAtPoint(point));
                Desktop desktop = Desktop.getDesktop();
                if (desktop.isSupported(Desktop.Action.BROWSE)) {
                    try {
                        desktop.browse(URI.create(MultiIdentificationDialog.this.profileForm.getPronumURLPrefix(puid)));
                    }
                    catch (IOException e) {
                        DialogUtils.showGeneralErrorDialog(MultiIdentificationDialog.this.profileForm.getDroidMainUi(), "IOException", "Resource not found.");
                    }
                }
            }
        }
    }

    private static final class PuidRenderer
    extends JLabel
    implements TableCellRenderer {
        private PuidRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setText("<html><a href=\"\">" + value + "</a></html>");
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }
}

