/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RowModel;
import org.openide.util.NbBundle;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;
import uk.gov.nationalarchives.droid.gui.DialogUtils;
import uk.gov.nationalarchives.droid.gui.DroidMainFrame;
import uk.gov.nationalarchives.droid.gui.DroidUIContext;
import uk.gov.nationalarchives.droid.gui.MultiIdentificationDialog;
import uk.gov.nationalarchives.droid.gui.ProfileTabComponent;
import uk.gov.nationalarchives.droid.gui.action.CloseProfileAction;
import uk.gov.nationalarchives.droid.gui.action.OpenContainingFolderAction;
import uk.gov.nationalarchives.droid.gui.action.SaveProfileWorker;
import uk.gov.nationalarchives.droid.gui.treemodel.DefaultMutableTreeNodeComparator;
import uk.gov.nationalarchives.droid.gui.treemodel.DirectoryComparableLong;
import uk.gov.nationalarchives.droid.gui.treemodel.ExpandingTreeListener;
import uk.gov.nationalarchives.droid.gui.treemodel.NodeRenderer;
import uk.gov.nationalarchives.droid.gui.treemodel.OutlineColumn;
import uk.gov.nationalarchives.droid.gui.treemodel.OutlineComparableComparator;
import uk.gov.nationalarchives.droid.gui.treemodel.ProfileRowModel;
import uk.gov.nationalarchives.droid.gui.treemodel.TreeUtils;
import uk.gov.nationalarchives.droid.gui.widgetwrapper.FileChooserProxyImpl;
import uk.gov.nationalarchives.droid.gui.widgetwrapper.JOptionPaneProxy;
import uk.gov.nationalarchives.droid.gui.worker.DroidJob;
import uk.gov.nationalarchives.droid.profile.ProfileEventListener;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.ProfileState;

public class ProfileForm
extends JPanel {
    private static final int MAX_LEVELS_TO_EXPAND = 3;
    private static final long serialVersionUID = 1671584434169040994L;
    private DefaultTreeModel treeModel;
    private OutlineModel mdl;
    private ProfileInstance profile;
    private DroidMainFrame droidMainUi;
    private DroidUIContext context;
    private ProfileEventListener listener;
    private ProfileTabComponent profileTab;
    private DroidJob job;
    private MultiIdentificationDialog multiIdentificationDialog;
    private final String puidValuePrefix = "<html><a href=\"\">";
    private final String puidValueSuffix = "</a></html>";
    private Map<Long, DefaultMutableTreeNode> inMemoryNodes = new HashMap<Long, DefaultMutableTreeNode>();
    private JMenuItem PopupAddFilesAndFolders;
    private JMenuItem PopupMenuCopyToClipboard;
    private JMenuItem PopupMenuExpandChildren;
    private JMenuItem PopupMenuExpandNextThree;
    private JMenuItem PopupOpenContainingFolder;
    private JMenuItem PopupRemoveFilesOrFolders;
    private JSeparator PopupSeparator1;
    private JPanel jPanel3;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JProgressBar profileProgressBar;
    private JPanel progressPanel;
    private Outline resultsOutline;
    private JLabel statusLabel;
    private JProgressBar statusProgressBar;
    private JPanel statusProgressPanel;
    private JLabel throttleLabel;
    private JPanel throttlePanel;
    private JSlider throttleSlider;

    public ProfileForm(DroidMainFrame droidMainUi, DroidUIContext context, ProfileEventListener listener) {
        this.droidMainUi = droidMainUi;
        this.context = context;
        this.listener = listener;
        this.initComponents();
        this.profileTab = new ProfileTabComponent(this);
        this.multiIdentificationDialog = new MultiIdentificationDialog(this);
        this.initOutline();
    }

    public ProfileForm(DroidMainFrame droidMainUi, DroidUIContext context, ProfileInstance profile, ProfileEventListener listener) {
        this(droidMainUi, context, listener);
        this.profile = profile;
    }

    private void initOutline() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(null, true);
        this.treeModel = new DefaultTreeModel(root, true);
        this.mdl = DefaultOutlineModel.createOutlineModel((TreeModel)this.treeModel, (RowModel)new ProfileRowModel(), (boolean)true, (String)"Resource");
        OutlineMouseAdapter mouseAdapter = new OutlineMouseAdapter();
        this.resultsOutline.addMouseListener((MouseListener)mouseAdapter);
        this.resultsOutline.addMouseMotionListener((MouseMotionListener)mouseAdapter);
        this.resultsOutline.setVisible(true);
        this.resultsOutline.setRootVisible(false);
        ExpandingTreeListener expandingTreeListener = new ExpandingTreeListener(this.droidMainUi.getProfileManager(), this);
        this.mdl.getTreePathSupport().addTreeWillExpandListener(expandingTreeListener);
        this.resultsOutline.setModel((TableModel)this.mdl);
        TableColumnModel columnModel = this.resultsOutline.getColumnModel();
        ETableColumn nodeColumn0 = (ETableColumn)columnModel.getColumn(0);
        Color backColor = this.resultsOutline.getBackground();
        nodeColumn0.setNestedComparator((Comparator)new DefaultMutableTreeNodeComparator(nodeColumn0));
        nodeColumn0.setCellRenderer((TableCellRenderer)((Object)new NodeRenderer(backColor)));
        this.resultsOutline.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new NodeRenderer(backColor)));
        this.resultsOutline.setShowHorizontalLines(false);
        this.resultsOutline.setShowVerticalLines(true);
        this.resultsOutline.setGridColor(TreeUtils.getDarkerColor(backColor));
        OutlineColumn[] columns = OutlineColumn.values();
        for (int i = 0; i < columns.length; ++i) {
            ETableColumn nodeColumn = (ETableColumn)columnModel.getColumn(i + 1);
            nodeColumn.setNestedComparator(new OutlineComparableComparator(nodeColumn));
            TableCellRenderer cellRenderer = OutlineColumn.values()[i].getRenderer(backColor);
            if (cellRenderer == null) continue;
            nodeColumn.setCellRenderer(cellRenderer);
        }
        this.resultsOutline.setAutoCreateColumnsFromModel(false);
        nodeColumn0 = (ETableColumn)columnModel.getColumn(0);
        int modelIndex = nodeColumn0.getModelIndex();
        this.resultsOutline.setColumnSorted(modelIndex, true, 1);
        this.jScrollPane1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (((ProfileForm)ProfileForm.this).resultsOutline.getPreferredSize().width <= ((ProfileForm)ProfileForm.this).jScrollPane1.getViewport().getExtentSize().width) {
                    ProfileForm.this.resultsOutline.setAutoResizeMode(2);
                } else {
                    ProfileForm.this.resultsOutline.setAutoResizeMode(0);
                }
            }
        });
        this.setDropFilesOn((JComponent)this.resultsOutline);
    }

    private void setDropFilesOn(JComponent component) {
        component.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                if (ProfileForm.this.profile.getState() == ProfileState.VIRGIN && ProfileForm.this.acceptDrop(evt)) {
                    evt.acceptDrop(1);
                    try {
                        List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        ProfileForm.this.droidMainUi.addFilesAndFolders(droppedFiles);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    evt.dropComplete(true);
                }
            }
        });
    }

    private boolean acceptDrop(DropTargetDropEvent evt) {
        boolean acceptDrop = false;
        for (DataFlavor flavour : evt.getCurrentDataFlavors()) {
            if (!flavour.equals(DataFlavor.javaFileListFlavor)) continue;
            acceptDrop = true;
            break;
        }
        return acceptDrop;
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.PopupAddFilesAndFolders = new JMenuItem();
        this.PopupRemoveFilesOrFolders = new JMenuItem();
        this.PopupSeparator1 = new JSeparator();
        this.PopupOpenContainingFolder = new JMenuItem();
        this.PopupMenuCopyToClipboard = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.PopupMenuExpandChildren = new JMenuItem();
        this.PopupMenuExpandNextThree = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.resultsOutline = new Outline();
        this.jPanel3 = new JPanel();
        this.statusProgressPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.statusProgressBar = new JProgressBar();
        this.throttlePanel = new JPanel();
        this.throttleSlider = new JSlider();
        this.throttleLabel = new JLabel();
        this.progressPanel = new JPanel();
        this.profileProgressBar = new JProgressBar();
        this.jPopupMenu1.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                ProfileForm.this.jPopupMenu1PopupMenuWillBecomeVisible(evt);
            }
        });
        this.jPopupMenu1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ProfileForm.this.jPopupMenu1ComponentShown(evt);
            }
        });
        this.PopupAddFilesAndFolders.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Add small.png")));
        this.PopupAddFilesAndFolders.setText(NbBundle.getMessage(ProfileForm.class, (String)"ProfileForm.PopupAddFilesAndFolders.text"));
        this.PopupAddFilesAndFolders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfileForm.this.PopupAddFilesAndFoldersActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.PopupAddFilesAndFolders);
        this.PopupRemoveFilesOrFolders.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Remove small.png")));
        this.PopupRemoveFilesOrFolders.setText(NbBundle.getMessage(ProfileForm.class, (String)"ProfileForm.PopupRemoveFilesOrFolders.text"));
        this.PopupRemoveFilesOrFolders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfileForm.this.PopupRemoveFilesOrFoldersActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.PopupRemoveFilesOrFolders);
        this.jPopupMenu1.add(this.PopupSeparator1);
        this.PopupOpenContainingFolder.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/icons/Icon_External_Link.png")));
        this.PopupOpenContainingFolder.setText(NbBundle.getMessage(ProfileForm.class, (String)"ProfileForm.PopupOpenContainingFolder.text"));
        this.PopupOpenContainingFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfileForm.this.PopupOpenContainingFolderActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.PopupOpenContainingFolder);
        this.PopupMenuCopyToClipboard.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Clipboard small.png")));
        this.PopupMenuCopyToClipboard.setText(NbBundle.getMessage(ProfileForm.class, (String)"ProfileForm.PopupMenuCopyToClipboard.text"));
        this.PopupMenuCopyToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfileForm.this.PopupMenuCopyToClipboardActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.PopupMenuCopyToClipboard);
        this.jPopupMenu1.add(this.jSeparator1);
        this.PopupMenuExpandChildren.setText(NbBundle.getMessage(ProfileForm.class, (String)"ProfileForm.PopupMenuExpandChildren.text"));
        this.PopupMenuExpandChildren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfileForm.this.PopupMenuExpandChildrenActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.PopupMenuExpandChildren);
        this.PopupMenuExpandNextThree.setText(NbBundle.getMessage(ProfileForm.class, (String)"ProfileForm.PopupMenuExpandNextThree.text"));
        this.PopupMenuExpandNextThree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfileForm.this.PopupMenuExpandNextThreeActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.PopupMenuExpandNextThree);
        this.resultsOutline.setAutoResizeMode(4);
        this.resultsOutline.setFillsViewportHeight(true);
        this.resultsOutline.setSelectVisibleColumnsLabel(NbBundle.getMessage(ProfileForm.class, (String)"results.columns.select"));
        this.jScrollPane1.setViewportView((Component)this.resultsOutline);
        this.statusLabel.setLabelFor(this.statusProgressBar);
        this.statusLabel.setText(NbBundle.getMessage(ProfileForm.class, (String)"ProfileForm.statusLabel.text"));
        GroupLayout statusProgressPanelLayout = new GroupLayout(this.statusProgressPanel);
        this.statusProgressPanel.setLayout(statusProgressPanelLayout);
        statusProgressPanelLayout.setHorizontalGroup(statusProgressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusProgressPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusLabel, -1, 94, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusProgressBar, -2, 125, -2).addContainerGap()));
        statusProgressPanelLayout.setVerticalGroup(statusProgressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statusProgressPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(statusProgressPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.statusProgressBar, -2, 14, -2).addComponent(this.statusLabel)).addContainerGap()));
        this.throttlePanel.setVisible(false);
        this.throttleSlider.setForeground(new Color(245, 246, 247));
        this.throttleSlider.setMaximum(1000);
        this.throttleSlider.setMinorTickSpacing(100);
        this.throttleSlider.setPaintLabels(true);
        this.throttleSlider.setPaintTicks(true);
        this.throttleSlider.setToolTipText(NbBundle.getMessage(ProfileForm.class, (String)"ProfileForm.throttleSlider.toolTipText"));
        this.throttleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ProfileForm.this.throttleSliderStateChanged(evt);
            }
        });
        this.throttleLabel.setText(NbBundle.getMessage(ProfileForm.class, (String)"ProfileForm.throttleLabel.text"));
        GroupLayout throttlePanelLayout = new GroupLayout(this.throttlePanel);
        this.throttlePanel.setLayout(throttlePanelLayout);
        throttlePanelLayout.setHorizontalGroup(throttlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(throttlePanelLayout.createSequentialGroup().addComponent(this.throttleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.throttleSlider, -1, 119, Short.MAX_VALUE).addContainerGap()));
        throttlePanelLayout.setVerticalGroup(throttlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(throttlePanelLayout.createSequentialGroup().addGroup(throttlePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.throttleSlider, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addGroup(throttlePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.throttleLabel))).addContainerGap(39, Short.MAX_VALUE)));
        this.profileProgressBar.setToolTipText(NbBundle.getMessage(ProfileForm.class, (String)"ProfileForm.profileProgressBar.toolTipText"));
        this.profileProgressBar.setString(NbBundle.getMessage(ProfileForm.class, (String)"ProfileForm.profileProgressBar.string"));
        this.profileProgressBar.setStringPainted(true);
        GroupLayout progressPanelLayout = new GroupLayout(this.progressPanel);
        this.progressPanel.setLayout(progressPanelLayout);
        progressPanelLayout.setHorizontalGroup(progressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(progressPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.profileProgressBar, -1, 386, Short.MAX_VALUE)));
        progressPanelLayout.setVerticalGroup(progressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(progressPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.profileProgressBar, -2, -1, -2)));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.progressPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusProgressPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.throttlePanel, -2, -1, -2)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.throttlePanel, -2, -1, -2).addComponent(this.progressPanel, -2, -1, -2).addComponent(this.statusProgressPanel, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 868, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 504, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 34, -2)));
    }

    private void PopupOpenContainingFolderActionPerformed(ActionEvent evt) {
        this.openSelectedFolders();
    }

    private void PopupAddFilesAndFoldersActionPerformed(ActionEvent evt) {
        this.droidMainUi.jButtonAddFileActionPerformed(evt);
    }

    private void PopupRemoveFilesOrFoldersActionPerformed(ActionEvent evt) {
        this.droidMainUi.jButtonRemoveFilesAndFolderActionPerformed(evt);
    }

    private void jPopupMenu1ComponentShown(ComponentEvent evt) {
        this.PopupAddFilesAndFolders.setEnabled(this.droidMainUi.getAddEnabled());
        this.PopupRemoveFilesOrFolders.setEnabled(this.droidMainUi.getRemoveEnabled());
    }

    private void jPopupMenu1PopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.PopupAddFilesAndFolders.setEnabled(this.droidMainUi.getAddEnabled());
        this.PopupRemoveFilesOrFolders.setEnabled(this.droidMainUi.getRemoveEnabled());
        this.PopupOpenContainingFolder.setEnabled(this.anyRowsSelected());
        this.PopupMenuCopyToClipboard.setEnabled(this.anyRowsSelected());
    }

    private void PopupMenuCopyToClipboardActionPerformed(ActionEvent evt) {
        this.copySelectedToClipboard();
    }

    private void PopupMenuExpandChildrenActionPerformed(ActionEvent evt) {
        this.expandSelectedNodes(false);
    }

    private void PopupMenuExpandNextThreeActionPerformed(ActionEvent evt) {
        this.expandSelectedNodes(true);
    }

    private void throttleSliderStateChanged(ChangeEvent evt) {
        this.throttleLabel.setText(String.format("Throttle: %s ms", this.throttleSlider.getValue()));
        this.context.getProfileManager().setThrottleValue(this.profile.getUuid(), this.throttleSlider.getValue());
    }

    public void copySelectedToClipboard() {
        TransferHandler handler = this.resultsOutline.getTransferHandler();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard clipboard = tk.getSystemClipboard();
        handler.exportToClipboard((JComponent)this.resultsOutline, clipboard, 1);
    }

    public Outline getResultsOutline() {
        return this.resultsOutline;
    }

    public JProgressBar getProfileProgressBar() {
        return this.profileProgressBar;
    }

    public JProgressBar getStatusProgressBar() {
        return this.statusProgressBar;
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setProfile(ProfileInstance profile) {
        this.profile = profile;
        profile.addEventListener(this.listener);
        this.listener.fireEvent(profile);
    }

    public ProfileInstance getProfile() {
        return this.profile;
    }

    public void closeProfile() {
        CloseProfileAction closeAction = new CloseProfileAction(this.droidMainUi.getProfileManager(), this.context, this);
        JOptionPaneProxy dialog = new JOptionPaneProxy(){

            @Override
            public int getResponse() {
                int result = JOptionPane.showConfirmDialog(ProfileForm.this, "Save this profile?", "Warning", 1, 2);
                int response = 3;
                if (result == 0) {
                    response = 1;
                } else if (result == 1) {
                    response = 2;
                }
                return response;
            }
        };
        closeAction.setUserOptionDialog(dialog);
        JFileChooser fileChooser = this.context.getProfileFileChooser();
        FileChooserProxyImpl chooserProxy = new FileChooserProxyImpl(this, fileChooser);
        closeAction.setSaveAction(new SaveProfileWorker(this.droidMainUi.getProfileManager(), this, chooserProxy));
        closeAction.start();
    }

    public void saveProfile(boolean saveAs) {
        JFileChooser fileChooser = this.context.getProfileFileChooser();
        fileChooser.setDialogTitle(String.format("Save profile '%s'", this.getName()));
        FileChooserProxyImpl dialog = new FileChooserProxyImpl(this, fileChooser);
        Path loadedFrom = this.getProfile().getLoadedFrom();
        fileChooser.setSelectedFile(loadedFrom != null ? loadedFrom.toFile() : new File(this.getName()));
        SaveProfileWorker worker = new SaveProfileWorker(this.droidMainUi.getProfileManager(), this, dialog);
        worker.start(saveAs);
    }

    public void beforeSave() {
        this.statusLabel.setText("Saving profile...");
        this.statusProgressBar.setValue(0);
        this.statusProgressBar.setIndeterminate(false);
        this.statusLabel.setVisible(true);
        this.statusProgressBar.setVisible(true);
    }

    private void openSelectedFolders() {
        OpenContainingFolderAction openAction = new OpenContainingFolderAction();
        openAction.open(this.getSelectedNodes());
    }

    public void afterSave() {
        this.statusLabel.setVisible(false);
        this.statusProgressBar.setVisible(false);
    }

    public void afterLoad() {
        this.throttleSlider.setValue(this.profile.getThrottle());
        this.throttlePanel.setVisible(true);
        this.getStatusProgressBar().setVisible(false);
        this.getStatusLabel().setVisible(false);
        this.listener.fireEvent(this.getProfile());
        this.droidMainUi.updateFilterControls();
    }

    public void afterCreate() {
        this.throttleSlider.setValue(this.profile.getThrottle());
        this.throttlePanel.setVisible(true);
    }

    public void setStateChangeListener(ProfileEventListener stateChangeListener) {
        this.listener = stateChangeListener;
    }

    public void start() {
        ProfileManager profileManager = this.droidMainUi.getProfileManager();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        this.inMemoryNodes.put(-1L, rootNode);
        this.job = new DroidJob();
        this.job.setProfileManager(profileManager);
        this.job.setProfileForm(this);
        this.job.start();
    }

    public void stop() {
        ProfileManager profileManager = this.droidMainUi.getProfileManager();
        profileManager.stop(this.getProfile().getUuid());
        this.job.cancel(true);
    }

    public ProfileTabComponent getProfileTab() {
        return this.profileTab;
    }

    public Map<Long, DefaultMutableTreeNode> getInMemoryNodes() {
        return this.inMemoryNodes;
    }

    public JSlider getThrottleSlider() {
        return this.throttleSlider;
    }

    JLabel getThrottleLabel() {
        return this.throttleLabel;
    }

    public ProfileEventListener getListener() {
        return this.listener;
    }

    public JPanel getProgressPanel() {
        return this.progressPanel;
    }

    public JPanel getThrottlePanel() {
        return this.throttlePanel;
    }

    DroidMainFrame getDroidMainUi() {
        return this.droidMainUi;
    }

    public List<ProfileResourceNode> getSelectedNodes() {
        ArrayList<ProfileResourceNode> results = new ArrayList<ProfileResourceNode>();
        Outline outline = this.getResultsOutline();
        int[] selectedRows = outline.getSelectedRows();
        for (int i = selectedRows.length; i > 0; --i) {
            int index = selectedRows[i - 1];
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)outline.getValueAt(index, 0);
            ProfileResourceNode prn = (ProfileResourceNode)treeNode.getUserObject();
            results.add(prn);
        }
        return results;
    }

    public boolean anyRowsSelected() {
        Outline outline = this.getResultsOutline();
        return outline.getSelectedRows().length > 0;
    }

    public void expandSelectedNodes(boolean recursive) {
        Outline outline = this.getResultsOutline();
        int[] selectedRows = outline.getSelectedRows();
        for (int i = selectedRows.length; i > 0; --i) {
            int index = selectedRows[i - 1];
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)outline.getValueAt(index, 0);
            this.expandNode(treeNode, recursive, 1);
        }
    }

    private void expandNode(DefaultMutableTreeNode treeNode, boolean recursive, int level) {
        if (treeNode.getAllowsChildren()) {
            if (treeNode.getChildCount() == 0) {
                TreePath path = new TreePath(treeNode.getPath());
                this.mdl.getTreePathSupport().expandPath(path);
            }
            if (recursive && level <= 3) {
                for (int childIndex = 0; childIndex < treeNode.getChildCount(); ++childIndex) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)treeNode.getChildAt(childIndex);
                    this.expandNode(child, recursive, level + 1);
                }
            }
        }
    }

    String getPronumURLPrefix(String puid) {
        String puidUrl = this.droidMainUi.getGlobalContext().getGlobalConfig().getProperties().getString(DroidGlobalProperty.PUID_URL_PATTERN.getName());
        return String.format(puidUrl, puid);
    }

    private class OutlineMouseAdapter
    extends MouseAdapter {
        private OutlineMouseAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 3) {
                Point mousePoint = e.getPoint();
                int rowIndex = ProfileForm.this.resultsOutline.rowAtPoint(mousePoint);
                if (rowIndex > -1 && !ProfileForm.this.resultsOutline.isRowSelected(rowIndex)) {
                    ProfileForm.this.resultsOutline.setRowSelectionInterval(rowIndex, rowIndex);
                }
                ProfileForm.this.jPopupMenu1.show((Component)ProfileForm.this.resultsOutline, e.getX(), e.getY());
            } else {
                Object cellObj;
                Point mousePoint = e.getPoint();
                int colIndex = ProfileForm.this.resultsOutline.columnAtPoint(mousePoint);
                int rowIndex = ProfileForm.this.resultsOutline.rowAtPoint(mousePoint);
                int colModelIndex = ProfileForm.this.resultsOutline.convertColumnIndexToModel(ProfileForm.this.resultsOutline.columnAtPoint(mousePoint));
                if (colModelIndex == OutlineColumn.PUID.ordinal() + 1 && (cellObj = ProfileForm.this.resultsOutline.getValueAt(rowIndex, colIndex)) != null) {
                    String cellValue = cellObj.toString();
                    cellValue = cellValue.replace("<html><a href=\"\">", "");
                    cellValue = cellValue.replace("</a></html>", "");
                    cellValue.trim();
                    if (cellValue.startsWith("\"")) {
                        String[] puids;
                        for (String puid : puids = StringUtils.split((String)cellValue, (String)",")) {
                            String unquotedPuid = StringUtils.strip((String)puid, (String)"\" ");
                            this.openURL(ProfileForm.this.getPronumURLPrefix(unquotedPuid));
                        }
                    } else if (cellValue.length() > 0) {
                        this.openURL(ProfileForm.this.getPronumURLPrefix(cellValue));
                    }
                }
            }
        }

        public void openURL(String puidUrl) {
            Desktop desktop = null;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                try {
                    URL url = new URL(puidUrl);
                    desktop.browse(url.toURI());
                }
                catch (MalformedURLException e1) {
                    DialogUtils.showGeneralErrorDialog(ProfileForm.this.droidMainUi, "MalformedURLException", "Invalid URL.");
                }
                catch (IOException e1) {
                    DialogUtils.showGeneralErrorDialog(ProfileForm.this.droidMainUi, "IOException", "Resource not found.");
                }
                catch (URISyntaxException uriSyntaxEx) {
                    DialogUtils.showGeneralErrorDialog(ProfileForm.this.droidMainUi, "URISyntaxException", "Invalid URI.");
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point mousePoint = e.getPoint();
            int colIndex = ProfileForm.this.resultsOutline.columnAtPoint(mousePoint);
            int rowIndex = ProfileForm.this.resultsOutline.rowAtPoint(mousePoint);
            int colModelIndex = ProfileForm.this.resultsOutline.convertColumnIndexToModel(ProfileForm.this.resultsOutline.columnAtPoint(mousePoint));
            Object cellObject = ProfileForm.this.resultsOutline.getValueAt(rowIndex, colIndex);
            if (cellObject != null) {
                String cellValue = cellObject.toString();
                ProfileForm.this.resultsOutline.setToolTipText(cellValue);
                if (colModelIndex == 0) {
                    ProfileResourceNode resourceNode = (ProfileResourceNode)((DefaultMutableTreeNode)cellObject).getUserObject();
                    ProfileForm.this.resultsOutline.setToolTipText(URLDecoder.decode(resourceNode.getUri().toString()));
                }
                if (colModelIndex == OutlineColumn.PUID.ordinal() + 1) {
                    cellValue = ProfileForm.this.resultsOutline.getValueAt(rowIndex, colIndex).toString();
                    cellValue = cellValue.replace("<html><a href=\"\">", "");
                    cellValue = cellValue.replace("</a></html>", "");
                    cellValue.trim();
                    if (cellValue.length() > 0) {
                        ProfileForm.this.setCursor(new Cursor(12));
                    } else {
                        ProfileForm.this.setCursor(new Cursor(0));
                    }
                } else if (colModelIndex == OutlineColumn.IDENTIFICATION_COUNT.ordinal() + 1) {
                    DirectoryComparableLong value = (DirectoryComparableLong)ProfileForm.this.resultsOutline.getValueAt(ProfileForm.this.resultsOutline.rowAtPoint(e.getPoint()), ProfileForm.this.resultsOutline.columnAtPoint(e.getPoint()));
                    if (value.getSource() != null && (Long)value.getSource() > 1L) {
                        ProfileForm.this.setCursor(new Cursor(12));
                    } else {
                        ProfileForm.this.setCursor(new Cursor(0));
                    }
                } else {
                    ProfileForm.this.setCursor(new Cursor(0));
                }
                ProfileForm.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DirectoryComparableLong count;
            Point mousePoint = e.getPoint();
            int colIndex = ProfileForm.this.resultsOutline.columnAtPoint(mousePoint);
            int rowIndex = ProfileForm.this.resultsOutline.rowAtPoint(mousePoint);
            int colModelIndex = ProfileForm.this.resultsOutline.convertColumnIndexToModel(ProfileForm.this.resultsOutline.columnAtPoint(mousePoint));
            if (colModelIndex == OutlineColumn.IDENTIFICATION_COUNT.ordinal() + 1 && (count = (DirectoryComparableLong)ProfileForm.this.resultsOutline.getValueAt(rowIndex, colIndex)) != null && count.getSource() != null && (Long)count.getSource() > 1L) {
                int rowModelIndex = ProfileForm.this.resultsOutline.convertRowIndexToModel(rowIndex);
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)ProfileForm.this.mdl.getValueAt(rowModelIndex, 0);
                ProfileResourceNode node = (ProfileResourceNode)treeNode.getUserObject();
                ProfileForm.this.multiIdentificationDialog.showDialog(node);
            }
        }
    }
}

