/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;
import uk.gov.nationalarchives.droid.gui.ProfileForm;

public class ProfileTabComponent
extends JPanel {
    private static final int BORDER_RIGHT = 5;
    private static final long serialVersionUID = -6007225851097990188L;
    private static final MouseListener BUTTON_MOUSE_LISTENER = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton btn = (AbstractButton)component;
                btn.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton btn = (AbstractButton)component;
                btn.setBorderPainted(false);
            }
        }
    };
    private ProfileForm parent;
    private JButton button;

    public ProfileTabComponent(ProfileForm parent) {
        super(new FlowLayout(0, 0, 0));
        this.parent = parent;
        this.setOpaque(false);
        final JLabel label = new JLabel();
        label.setText(parent.getName());
        parent.addPropertyChangeListener("name", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                label.setText(evt.getNewValue().toString());
            }
        });
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.button = new CloseTabButton();
        this.button.setVisible(false);
        this.add(this.button);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    public void setButtonVisible(boolean visible) {
        this.button.setVisible(visible);
    }

    private class CloseTabButton
    extends JButton
    implements ActionListener {
        private static final int DELTA = 6;
        private static final int BUTTON_SIZE = 17;
        private static final long serialVersionUID = -5319241984819540576L;
        private final BasicStroke stroke = new BasicStroke(2.0f);

        public CloseTabButton() {
            this.setPreferredSize(new Dimension(17, 17));
            this.setToolTipText("close this profile");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(BUTTON_MOUSE_LISTENER);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProfileTabComponent.this.parent.closeProfile();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.setStroke(this.stroke);
            g2.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                g2.setColor(Color.RED);
            }
            g2.drawLine(6, 6, this.getWidth() - 6 - 1, this.getHeight() - 6 - 1);
            g2.drawLine(this.getWidth() - 6 - 1, 6, 6, this.getHeight() - 6 - 1);
            g2.dispose();
        }
    }
}

