/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui;

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import org.openide.util.NbBundle;
import uk.gov.nationalarchives.droid.gui.CheckListCellModel;
import uk.gov.nationalarchives.droid.gui.CheckListRenderer;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.gui.widgetwrapper.ProfileSelectionDialog;

public class SaveAllProfilesDialog
extends JDialog
implements ProfileSelectionDialog {
    private static final long serialVersionUID = 4458147031080987135L;
    private List<CheckListCellModel> model = new ArrayList<CheckListCellModel>();
    private int action = 3;
    private List<ProfileForm> profiles;
    private ListModel listModel;
    private JButton cancelButton;
    private JButton dontsaveButton;
    private JLabel instructionLabel;
    private JList jList1;
    private JScrollPane jScrollPane2;
    private JButton saveButton;

    public SaveAllProfilesDialog(Frame owner, List<ProfileForm> profiles) {
        super(owner, "Save profiles");
        this.profiles = profiles;
        for (ProfileForm profile : profiles) {
            this.model.add(new CheckListCellModel(profile.getName(), true));
        }
        this.listModel = new AbstractListModel(){
            private static final long serialVersionUID = -3790566823193174377L;

            @Override
            public int getSize() {
                return SaveAllProfilesDialog.this.model.size();
            }

            @Override
            public Object getElementAt(int index) {
                return SaveAllProfilesDialog.this.model.get(index);
            }
        };
        this.initComponents();
        this.jList1.setCellRenderer(new CheckListRenderer());
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = SaveAllProfilesDialog.this.jList1.locationToIndex(e.getPoint());
                CheckListCellModel cell = (CheckListCellModel)SaveAllProfilesDialog.this.model.get(index);
                cell.toggleSelection();
                Rectangle rect = SaveAllProfilesDialog.this.jList1.getCellBounds(index, index);
                SaveAllProfilesDialog.this.jList1.repaint(rect);
            }
        });
        this.setLocationRelativeTo(owner);
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.saveButton = new JButton();
        this.instructionLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.dontsaveButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.cancelButton.setText(NbBundle.getMessage(SaveAllProfilesDialog.class, (String)"SaveAllProfilesDialog.cancelButton.text_1"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveAllProfilesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.saveButton.setText(NbBundle.getMessage(SaveAllProfilesDialog.class, (String)"SaveAllProfilesDialog.saveButton.text_1"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveAllProfilesDialog.this.saveButtonActionPerformed(evt);
            }
        });
        this.instructionLabel.setText(NbBundle.getMessage(SaveAllProfilesDialog.class, (String)"SaveAllProfilesDialog.instructionLabel.text"));
        this.jList1.setBorder(BorderFactory.createEtchedBorder());
        this.jList1.setModel(this.listModel);
        this.jList1.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.jList1);
        this.dontsaveButton.setText(NbBundle.getMessage(SaveAllProfilesDialog.class, (String)"SaveAllProfilesDialog.dontsaveButton.text"));
        this.dontsaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveAllProfilesDialog.this.dontsaveButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 290, Short.MAX_VALUE).addComponent(this.instructionLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.dontsaveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 71, Short.MAX_VALUE).addComponent(this.saveButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.instructionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane2, -1, 184, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dontsaveButton).addComponent(this.cancelButton).addComponent(this.saveButton)).addContainerGap()));
        this.pack();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.action = 1;
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.action = 3;
        this.setVisible(false);
        this.dispose();
    }

    private void dontsaveButtonActionPerformed(ActionEvent evt) {
        this.setSaveState(false);
        this.action = 1;
        this.setVisible(false);
        this.dispose();
    }

    private void setSaveState(boolean saveState) {
        for (int profileIndex = 0; profileIndex < this.model.size(); ++profileIndex) {
            CheckListCellModel profile = this.model.get(profileIndex);
            profile.setSelection(saveState);
        }
    }

    @Override
    public int getResponse() {
        return this.action;
    }

    @Override
    public List<ProfileForm> getSelectedProfiles() {
        ArrayList<ProfileForm> selectedProfiles = new ArrayList<ProfileForm>();
        for (int profileIndex = 0; profileIndex < this.model.size(); ++profileIndex) {
            CheckListCellModel cell = this.model.get(profileIndex);
            if (!cell.isSelected()) continue;
            selectedProfiles.add(this.profiles.get(profileIndex));
        }
        return selectedProfiles;
    }

    @Override
    public void open() {
        this.setVisible(true);
    }

    List<CheckListCellModel> getModel() {
        return this.model;
    }
}

