/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingWorker;
import uk.gov.nationalarchives.droid.gui.DroidUIContext;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.gui.action.SaveProfileWorker;
import uk.gov.nationalarchives.droid.gui.widgetwrapper.JOptionPaneProxy;
import uk.gov.nationalarchives.droid.profile.ProfileManager;

public class CloseProfileAction {
    private ProfileManager profileManager;
    private DroidUIContext context;
    private ProfileForm parent;
    private JOptionPaneProxy userOptionDialog;
    private SaveProfileWorker saveAction;

    public CloseProfileAction(ProfileManager profileManager, DroidUIContext context, ProfileForm parent) {
        this.profileManager = profileManager;
        this.context = context;
        this.parent = parent;
    }

    public void start() {
        if (!this.parent.getProfile().isDirty()) {
            this.closeAndRemove(this.parent.getProfile().getUuid());
        } else {
            int response = this.userOptionDialog.getResponse();
            if (response == 2) {
                String profileId = this.parent.getProfile().getUuid();
                this.profileManager.closeProfile(profileId);
                this.context.remove(profileId);
            } else if (response == 1) {
                this.saveAction.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        if ("state".equals(event.getPropertyName()) && event.getNewValue() == SwingWorker.StateValue.DONE && !CloseProfileAction.this.saveAction.isCancelled()) {
                            CloseProfileAction.this.closeAndRemove(CloseProfileAction.this.parent.getProfile().getUuid());
                        }
                    }
                });
                this.saveAction.start(false);
            }
        }
    }

    private void closeAndRemove(String profileId) {
        this.context.remove(this.parent.getProfile().getUuid());
        this.profileManager.closeProfile(this.parent.getProfile().getUuid());
    }

    public void setUserOptionDialog(JOptionPaneProxy dialog) {
        this.userOptionDialog = dialog;
    }

    public void setSaveAction(SaveProfileWorker saveAction) {
        this.saveAction = saveAction;
    }
}

