/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.gui.DroidUIContext;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.gui.action.SaveProfileWorker;
import uk.gov.nationalarchives.droid.gui.widgetwrapper.FileChooserProxyImpl;
import uk.gov.nationalarchives.droid.gui.widgetwrapper.ProfileSelectionDialog;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileManager;

public class ExitAction
extends SwingWorker<Void, Void> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private DroidUIContext context;
    private ProfileSelectionDialog dialog;
    private ProfileManager profileManager;
    private CountDownLatch latch;

    public ExitAction(DroidUIContext context, ProfileSelectionDialog dialog, ProfileManager profileManager) {
        this.context = context;
        this.dialog = dialog;
        this.profileManager = profileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ArrayList<ProfileForm> allProfiles = new ArrayList<ProfileForm>(this.context.allProfiles());
        this.latch = new CountDownLatch(allProfiles.size());
        List<ProfileForm> dirtyProfiles = this.context.allDirtyProfiles();
        if (!dirtyProfiles.isEmpty()) {
            this.dialog.open();
            int response = this.dialog.getResponse();
            if (response == 1) {
                List<ProfileForm> profilesToSave = this.dialog.getSelectedProfiles();
                for (ProfileForm profile : profilesToSave) {
                    allProfiles.remove(profile);
                    JFileChooser fileChooser = this.context.getProfileFileChooser();
                    fileChooser.setDialogTitle(String.format("Save profile '%s'", profile.getName()));
                    FileChooserProxyImpl fileChooserDialog = new FileChooserProxyImpl(profile, fileChooser);
                    java.nio.file.Path loadedFrom = profile.getProfile().getLoadedFrom();
                    fileChooser.setSelectedFile(loadedFrom != null ? loadedFrom.toFile() : new File(profile.getName()));
                    SaveProfileWorker saveJob = new SaveProfileWorker(this.profileManager, profile, fileChooserDialog);
                    saveJob.addPropertyChangeListener(new SaveJobCompletionListener());
                    saveJob.start(false);
                }
            } else {
                this.cancel(true);
            }
        }
        if (!this.isCancelled()) {
            this.execute();
            for (ProfileForm profile : allProfiles) {
                try {
                    this.profileManager.closeProfile(profile.getProfile().getUuid());
                    this.context.remove(profile.getProfile().getUuid());
                }
                finally {
                    this.latch.countDown();
                }
            }
        }
    }

    @Override
    protected Void doInBackground() throws InterruptedException {
        this.latch.await();
        return null;
    }

    private class Path {
        private Path() {
        }
    }

    private final class SaveJobCompletionListener
    implements PropertyChangeListener {
        private SaveJobCompletionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                try {
                    Future job = (Future)evt.getSource();
                    ProfileInstance profile = (ProfileInstance)job.get();
                    ExitAction.this.profileManager.closeProfile(profile.getUuid());
                    ExitAction.this.context.remove(profile.getUuid());
                }
                catch (InterruptedException e) {
                    ExitAction.this.log.debug(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (ExecutionException e) {
                    ExitAction.this.cancel(true);
                    ExitAction.this.log.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
                finally {
                    ExitAction.this.latch.countDown();
                }
            }
        }
    }
}

