/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.action;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;

public class OpenContainingFolderAction {
    private static final String FILE_URI_PREFIX = "file:/";

    public void open(List<ProfileResourceNode> nodes) {
        if (Desktop.isDesktopSupported()) {
            Set<String> folderPaths = this.getClosestFolderPaths(nodes);
            this.openFolders(folderPaths);
        }
    }

    private void openFolders(Set<String> locations) {
        Desktop desktop = Desktop.getDesktop();
        for (String path : locations) {
            File folder = new File(path);
            if (!folder.exists() || !folder.isDirectory()) continue;
            try {
                desktop.open(folder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Set<String> getClosestFolderPaths(List<ProfileResourceNode> nodes) {
        HashSet<String> closestFolderPaths = new HashSet<String>();
        for (ProfileResourceNode node : nodes) {
            String closestFolderPath = this.getClosestFolderPath(this.getClosestFilePath(node.getUri()));
            if (closestFolderPath == null || closestFolderPath.isEmpty()) continue;
            closestFolderPaths.add(closestFolderPath);
        }
        return closestFolderPaths;
    }

    private String getClosestFolderPath(String filePath) {
        String closestFolderPath = null;
        File theFile = new File(filePath);
        if (theFile.exists()) {
            File parentFolder = theFile.getParentFile();
            closestFolderPath = parentFolder == null ? null : parentFolder.getAbsolutePath();
        }
        return closestFolderPath;
    }

    private String getClosestFilePath(URI location) {
        int filePrefixEnd;
        String path = URLDecoder.decode(location.toString());
        int firstPling = path.indexOf(33, filePrefixEnd = path.indexOf(FILE_URI_PREFIX) + FILE_URI_PREFIX.length());
        int endOfFilePath = firstPling > 0 ? firstPling : path.length();
        String uriPath = path.substring(filePrefixEnd, endOfFilePath);
        return path.charAt(filePrefixEnd + 1) == ':' || path.startsWith("///") ? uriPath : '/' + uriPath;
    }
}

