/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.config;

import java.awt.Window;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JOptionPane;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileException;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureManager;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureType;

public class InstallSignatureFileAction {
    private SignatureManager signatureManager;
    private String fileName;
    private boolean useAsDefault;
    private SignatureType type;

    public InstallSignatureFileAction() {
    }

    public InstallSignatureFileAction(String filename, SignatureType signatureType, SignatureManager signatureManager, boolean useAsDefault) {
        this.setFileName(filename);
        this.setType(signatureType);
        this.setSignatureManager(signatureManager);
        this.setUseAsDefault(useAsDefault);
    }

    public void execute(Window parent) {
        Path f = Paths.get(this.fileName, new String[0]);
        try {
            SignatureFileInfo info = this.signatureManager.install(this.type, f, this.useAsDefault);
            String message = String.format("Signature file %s has been installed", info.getFile().getFileName().toString());
            JOptionPane.showMessageDialog(parent, message, "Signature file installed", 1);
        }
        catch (SignatureFileException e) {
            JOptionPane.showMessageDialog(parent, e.getMessage(), "Error installing signature file", 0);
        }
    }

    public void setSignatureManager(SignatureManager signatureManager) {
        this.signatureManager = signatureManager;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setUseAsDefault(boolean useAsDefault) {
        this.useAsDefault = useAsDefault;
    }

    public void setType(SignatureType type) {
        this.type = type;
    }
}

