/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.event;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import uk.gov.nationalarchives.droid.gui.DroidUIContext;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.profile.FilterImpl;
import uk.gov.nationalarchives.droid.profile.ProfileEventListener;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileState;

public class ButtonManager
implements ProfileEventListener {
    private Set<JComponent> resourceEditing = new HashSet<JComponent>();
    private Set<JComponent> runAction = new HashSet<JComponent>();
    private Set<JComponent> stopAction = new HashSet<JComponent>();
    private Set<JComponent> saveAction = new HashSet<JComponent>();
    private Set<JComponent> loadAction = new HashSet<JComponent>();
    private Set<JComponent> createAction = new HashSet<JComponent>();
    private Set<JComponent> saveAsAction = new HashSet<JComponent>();
    private Set<JComponent> closeAction = new HashSet<JComponent>();
    private Set<JComponent> exportAction = new HashSet<JComponent>();
    private Set<JComponent> filterAction = new HashSet<JComponent>();
    private Set<JComponent> filterEnabledAction = new HashSet<JComponent>();
    private Set<JComponent> reportAction = new HashSet<JComponent>();
    private Map<ProfileState, ProfileStateMachine> states = new HashMap<ProfileState, ProfileStateMachine>();
    private DroidUIContext context;

    public ButtonManager(DroidUIContext context) {
        this.context = context;
        this.states.put(ProfileState.VIRGIN, new VirginState());
        this.states.put(ProfileState.STOPPED, new StoppedState());
        this.states.put(ProfileState.RUNNING, new RunningState());
        this.states.put(ProfileState.INITIALISING, new InitialisingState());
        this.states.put(ProfileState.LOADING, new LoadingState());
        this.states.put(ProfileState.SAVING, new SavingState());
        this.states.put(ProfileState.FINISHED, new FinishedState());
    }

    public void fireEvent(final ProfileInstance profile) {
        final ProfileForm activeProfile = this.context.getSelectedProfile();
        if (activeProfile == null || activeProfile.getProfile() == null) {
            this.setEnabled(this.saveAsAction, false);
            this.setEnabled(this.saveAction, false);
            this.setEnabled(this.loadAction, true);
            this.setEnabled(this.createAction, true);
            this.setEnabled(this.runAction, false);
            this.setEnabled(this.stopAction, false);
            this.setEnabled(this.resourceEditing, false);
            this.setEnabled(this.closeAction, false);
            this.setEnabled(this.exportAction, false);
            this.setEnabled(this.filterAction, false);
            this.setEnabled(this.filterEnabledAction, false);
            this.setEnabled(this.reportAction, false);
        } else if (activeProfile.getProfile().equals(profile)) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfileStateMachine state = (ProfileStateMachine)ButtonManager.this.states.get(profile.getState());
                    if (state != null) {
                        state.onEnter(activeProfile);
                    }
                }
            });
        }
    }

    private void setEnabled(Set<JComponent> components, boolean enabled) {
        for (JComponent component : components) {
            component.setEnabled(enabled);
        }
    }

    public void addSaveAsComponent(JComponent c) {
        this.saveAsAction.add(c);
    }

    public void addSaveComponent(JComponent c) {
        this.saveAction.add(c);
    }

    public void addLoadComponent(JComponent c) {
        this.loadAction.add(c);
    }

    public void addCreateComponent(JComponent c) {
        this.createAction.add(c);
    }

    public void addRunComponent(JComponent c) {
        this.runAction.add(c);
    }

    public void addStopComponent(JComponent c) {
        this.stopAction.add(c);
    }

    public void addResourceComponent(JComponent c) {
        this.resourceEditing.add(c);
    }

    public void addCloseComponent(JComponent c) {
        this.closeAction.add(c);
    }

    public void addExportComponent(JComponent c) {
        this.exportAction.add(c);
    }

    public void addFilterComponent(JComponent c) {
        this.filterAction.add(c);
    }

    public void addFilterEnabledComponent(JComponent c) {
        this.filterEnabledAction.add(c);
    }

    public void addReportComponent(JComponent c) {
        this.reportAction.add(c);
    }

    private static boolean allProfilesExportable(Collection<ProfileForm> profiles) {
        for (ProfileForm profile : profiles) {
            ProfileState state = profile.getProfile().getState();
            if (state.equals((Object)ProfileState.STOPPED) || state.equals((Object)ProfileState.FINISHED)) continue;
            return false;
        }
        return true;
    }

    private static boolean atLeastOneProfileExportable(Collection<ProfileForm> profiles) {
        ProfileForm profile;
        boolean isExportable = false;
        Iterator<ProfileForm> iterator = profiles.iterator();
        while (iterator.hasNext() && !(isExportable = (profile = iterator.next()).getProfile().getState().isReportable())) {
        }
        return isExportable;
    }

    private static boolean atLeastOneProfileReportable(Collection<ProfileForm> profiles) {
        ProfileForm profile;
        boolean isReportable = false;
        Iterator<ProfileForm> iterator = profiles.iterator();
        while (iterator.hasNext() && !(isReportable = (profile = iterator.next()).getProfile().getState().isReportable())) {
        }
        return isReportable;
    }

    private static boolean isFilterable(ProfileForm profile) {
        ProfileState state = profile.getProfile().getState();
        return state.equals((Object)ProfileState.STOPPED) || state.equals((Object)ProfileState.FINISHED);
    }

    private static boolean isFilterEnabled(ProfileForm profile) {
        FilterImpl filter = profile.getProfile().getFilter();
        return filter != null && filter.hasCriteria();
    }

    public static boolean hasResources(ProfileForm profileForm) {
        return !profileForm.getProfile().getProfileSpec().getResources().isEmpty();
    }

    private static abstract class AbstractState
    implements ProfileStateMachine {
        private AbstractState() {
        }
    }

    private final class LoadingState
    extends AbstractState {
        private LoadingState() {
        }

        @Override
        public void onEnter(ProfileForm profileForm) {
            ButtonManager.this.setEnabled(ButtonManager.this.saveAsAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.saveAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.loadAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.createAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.runAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.stopAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.resourceEditing, false);
            profileForm.getProfileTab().setButtonVisible(false);
            ButtonManager.this.setEnabled(ButtonManager.this.closeAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.exportAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.filterAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.filterEnabledAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.reportAction, false);
            profileForm.getProgressPanel().setVisible(false);
        }
    }

    private final class SavingState
    extends AbstractState {
        private SavingState() {
        }

        @Override
        public void onEnter(ProfileForm profileForm) {
            ButtonManager.this.setEnabled(ButtonManager.this.saveAsAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.saveAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.loadAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.createAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.runAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.stopAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.resourceEditing, false);
            profileForm.getProfileTab().setButtonVisible(false);
            ButtonManager.this.setEnabled(ButtonManager.this.closeAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.exportAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.filterAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.filterEnabledAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.reportAction, false);
        }
    }

    private final class InitialisingState
    extends AbstractState {
        private InitialisingState() {
        }

        @Override
        public void onEnter(ProfileForm profileForm) {
            ButtonManager.this.setEnabled(ButtonManager.this.saveAsAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.saveAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.loadAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.createAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.runAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.stopAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.resourceEditing, true);
            profileForm.getProfileTab().setButtonVisible(false);
            ButtonManager.this.setEnabled(ButtonManager.this.closeAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.exportAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.filterAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.filterEnabledAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.reportAction, false);
            profileForm.getProgressPanel().setVisible(false);
            profileForm.getThrottlePanel().setVisible(false);
        }
    }

    private final class RunningState
    extends AbstractState {
        private RunningState() {
        }

        @Override
        public void onEnter(ProfileForm profileForm) {
            ButtonManager.this.setEnabled(ButtonManager.this.saveAsAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.saveAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.loadAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.createAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.runAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.stopAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.resourceEditing, false);
            ButtonManager.this.setEnabled(ButtonManager.this.closeAction, false);
            profileForm.getProfileTab().setButtonVisible(false);
            ButtonManager.this.setEnabled(ButtonManager.this.exportAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.filterAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.filterEnabledAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.reportAction, false);
            profileForm.getProgressPanel().setVisible(true);
        }
    }

    private final class FinishedState
    extends AbstractState {
        private FinishedState() {
        }

        @Override
        public void onEnter(ProfileForm profileForm) {
            ButtonManager.this.setEnabled(ButtonManager.this.saveAsAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.saveAction, profileForm.getProfile().isDirty());
            ButtonManager.this.setEnabled(ButtonManager.this.loadAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.createAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.runAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.stopAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.resourceEditing, false);
            ButtonManager.this.setEnabled(ButtonManager.this.closeAction, true);
            profileForm.getProfileTab().setButtonVisible(true);
            ButtonManager.this.setEnabled(ButtonManager.this.exportAction, ButtonManager.atLeastOneProfileExportable(ButtonManager.this.context.allProfiles()));
            ButtonManager.this.setEnabled(ButtonManager.this.filterAction, ButtonManager.isFilterable(profileForm));
            ButtonManager.this.setEnabled(ButtonManager.this.filterEnabledAction, ButtonManager.isFilterEnabled(profileForm));
            ButtonManager.this.setEnabled(ButtonManager.this.reportAction, ButtonManager.atLeastOneProfileReportable(ButtonManager.this.context.allProfiles()));
            profileForm.getProgressPanel().setVisible(false);
            profileForm.getThrottlePanel().setVisible(false);
        }
    }

    private final class VirginState
    extends AbstractState {
        private VirginState() {
        }

        @Override
        public void onEnter(ProfileForm profileForm) {
            ButtonManager.this.setEnabled(ButtonManager.this.saveAsAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.saveAction, profileForm.getProfile().isDirty());
            ButtonManager.this.setEnabled(ButtonManager.this.loadAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.createAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.runAction, ButtonManager.hasResources(profileForm));
            ButtonManager.this.setEnabled(ButtonManager.this.stopAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.resourceEditing, true);
            ButtonManager.this.setEnabled(ButtonManager.this.closeAction, true);
            profileForm.getProfileTab().setButtonVisible(true);
            ButtonManager.this.setEnabled(ButtonManager.this.exportAction, ButtonManager.atLeastOneProfileExportable(ButtonManager.this.context.allProfiles()));
            ButtonManager.this.setEnabled(ButtonManager.this.filterAction, ButtonManager.isFilterable(profileForm));
            ButtonManager.this.setEnabled(ButtonManager.this.filterEnabledAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.reportAction, ButtonManager.atLeastOneProfileReportable(ButtonManager.this.context.allProfiles()));
            profileForm.getProgressPanel().setVisible(true);
        }
    }

    private final class StoppedState
    extends AbstractState {
        private StoppedState() {
        }

        @Override
        public void onEnter(ProfileForm profileForm) {
            ButtonManager.this.setEnabled(ButtonManager.this.saveAsAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.saveAction, profileForm.getProfile().isDirty());
            ButtonManager.this.setEnabled(ButtonManager.this.loadAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.createAction, true);
            ButtonManager.this.setEnabled(ButtonManager.this.runAction, ButtonManager.hasResources(profileForm));
            ButtonManager.this.setEnabled(ButtonManager.this.stopAction, false);
            ButtonManager.this.setEnabled(ButtonManager.this.resourceEditing, false);
            ButtonManager.this.setEnabled(ButtonManager.this.closeAction, true);
            profileForm.getProfileTab().setButtonVisible(true);
            ButtonManager.this.setEnabled(ButtonManager.this.exportAction, ButtonManager.atLeastOneProfileExportable(ButtonManager.this.context.allProfiles()));
            ButtonManager.this.setEnabled(ButtonManager.this.filterAction, ButtonManager.isFilterable(profileForm));
            ButtonManager.this.setEnabled(ButtonManager.this.filterEnabledAction, ButtonManager.isFilterEnabled(profileForm));
            ButtonManager.this.setEnabled(ButtonManager.this.reportAction, ButtonManager.atLeastOneProfileReportable(ButtonManager.this.context.allProfiles()));
            profileForm.getProgressPanel().setVisible(true);
        }
    }

    private static interface ProfileStateMachine {
        public void onEnter(ProfileForm var1);
    }
}

