/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.openide.util.NbBundle;
import uk.gov.nationalarchives.droid.export.interfaces.ExportOptions;
import uk.gov.nationalarchives.droid.gui.DroidMainFrame;
import uk.gov.nationalarchives.droid.gui.ProfileForm;

public class ExportDialog
extends JDialog {
    private static final long serialVersionUID = -4598078880004073202L;
    private DroidMainFrame droidMain;
    private DefaultTableModel tableModel;
    private List<ProfileWrapper> profilesRowData;
    private boolean approved;
    private JRadioButton RadioOneRowPerFile;
    private JRadioButton RadioOneRowPerIdentification;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JComboBox cmdEncoding;
    private JButton exportButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel profileSelectLabel;
    private JTable profileSelectTable;

    public ExportDialog(DroidMainFrame parent) {
        super(parent);
        this.droidMain = parent;
        this.setModal(true);
        this.initComponents();
        this.jScrollPane1.getViewport().setBackground(this.profileSelectTable.getBackground());
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void showDialog() {
        this.profilesRowData = new ArrayList<ProfileWrapper>();
        Collection<ProfileForm> profiles = this.droidMain.getDroidContext().allProfiles();
        for (ProfileForm profileForm : profiles) {
            this.profilesRowData.add(new ProfileWrapper(profileForm));
        }
        this.tableModel = new DefaultTableModel(0, 1){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return ProfileForm.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return ((ProfileWrapper)ExportDialog.this.profilesRowData.get(row)).getProfile().getProfile().getState().isReportable();
            }
        };
        for (ProfileWrapper profileWrapper : this.profilesRowData) {
            Object[] row = new Object[]{profileWrapper};
            this.tableModel.addRow(row);
        }
        this.profileSelectTable.setModel(this.tableModel);
        this.profileSelectTable.setDefaultEditor(ProfileForm.class, new CheckBoxEditor());
        this.profileSelectTable.setDefaultRenderer(ProfileForm.class, new CheckBoxRenderer());
        this.jScrollPane1.setColumnHeaderView(null);
        this.profileSelectTable.setCellSelectionEnabled(false);
        this.enableGenerateButton();
        this.approved = false;
        this.setVisible(true);
    }

    public ExportOptions getExportOptions() {
        if (this.RadioOneRowPerFile.isSelected()) {
            return ExportOptions.ONE_ROW_PER_FILE;
        }
        return ExportOptions.ONE_ROW_PER_FORMAT;
    }

    public String getOutputEncoding() {
        CharsetEncodingItem encoding = (CharsetEncodingItem)this.cmdEncoding.getSelectedItem();
        return encoding.getCharset().name();
    }

    public boolean isBom() {
        CharsetEncodingItem encoding = (CharsetEncodingItem)this.cmdEncoding.getSelectedItem();
        return encoding.isBom();
    }

    public void setExportOptions(ExportOptions options) {
        if (options.equals((Object)ExportOptions.ONE_ROW_PER_FILE)) {
            this.RadioOneRowPerFile.setSelected(true);
        } else if (options.equals((Object)ExportOptions.ONE_ROW_PER_FORMAT)) {
            this.RadioOneRowPerIdentification.setSelected(true);
        }
    }

    public List<String> getSelectedProfileIds() {
        ArrayList<String> selectedProfiles = new ArrayList<String>();
        for (ProfileWrapper profileWrapper : this.profilesRowData) {
            if (!profileWrapper.isSelected()) continue;
            selectedProfiles.add(profileWrapper.getProfile().getProfile().getUuid());
        }
        return selectedProfiles;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.profileSelectLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.profileSelectTable = new JTable();
        this.jPanel1 = new JPanel();
        this.cancelButton = new JButton();
        this.exportButton = new JButton();
        this.RadioOneRowPerFile = new JRadioButton();
        this.RadioOneRowPerIdentification = new JRadioButton();
        this.cmdEncoding = new JComboBox();
        this.jLabel1 = new JLabel();
        this.setTitle(NbBundle.getMessage(ExportDialog.class, (String)"ExportDialog.title_1"));
        this.setAlwaysOnTop(true);
        this.setName("exportDialog");
        this.profileSelectLabel.setText(NbBundle.getMessage(ExportDialog.class, (String)"ExportDialog.profileSelectLabel.text_1"));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 402));
        this.profileSelectTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1"}));
        this.profileSelectTable.setRowHeight(20);
        this.profileSelectTable.setRowSelectionAllowed(false);
        this.profileSelectTable.setShowHorizontalLines(false);
        this.profileSelectTable.setShowVerticalLines(false);
        this.profileSelectTable.setTableHeader(null);
        this.jScrollPane1.setViewportView(this.profileSelectTable);
        this.cancelButton.setText(NbBundle.getMessage(ExportDialog.class, (String)"ExportDialog.cancelButton.text"));
        this.cancelButton.setVerticalAlignment(3);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.exportButton.setText(NbBundle.getMessage(ExportDialog.class, (String)"ExportDialog.generateButton.text"));
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.exportButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.RadioOneRowPerFile);
        this.RadioOneRowPerFile.setSelected(true);
        this.RadioOneRowPerFile.setText(NbBundle.getMessage(ExportDialog.class, (String)"ExportDialog.RadioOneRowPerFile.text"));
        this.RadioOneRowPerFile.setToolTipText(NbBundle.getMessage(ExportDialog.class, (String)"ExportDialog.RadioOneRowPerFile.toolTipText"));
        this.buttonGroup1.add(this.RadioOneRowPerIdentification);
        this.RadioOneRowPerIdentification.setText(NbBundle.getMessage(ExportDialog.class, (String)"ExportDialog.RadioOneRowPerIdentification.text"));
        this.RadioOneRowPerIdentification.setToolTipText(NbBundle.getMessage(ExportDialog.class, (String)"ExportDialog.RadioOneRowPerIdentification.toolTipText"));
        this.cmdEncoding.setModel(this.getOutputEncodings());
        this.jLabel1.setText(NbBundle.getMessage(ExportDialog.class, (String)"ExportDialog.jLabel1.text_1"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.cmdEncoding, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.exportButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 125, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.RadioOneRowPerFile).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.RadioOneRowPerIdentification).addGap(0, 145, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.RadioOneRowPerFile).addComponent(this.RadioOneRowPerIdentification)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.exportButton).addComponent(this.cmdEncoding, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, -1, Short.MAX_VALUE).addComponent(this.profileSelectLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.profileSelectLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 232, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
    }

    protected void exportButtonActionPerformed(ActionEvent evt) {
        this.approved = true;
        this.setVisible(false);
    }

    private void enableGenerateButton() {
        boolean profileSelected = false;
        for (ProfileWrapper profileWrapper : this.profilesRowData) {
            if (!profileWrapper.isSelected()) continue;
            profileSelected = true;
            break;
        }
        this.exportButton.setEnabled(profileSelected);
    }

    private ComboBoxModel getOutputEncodings() {
        DefaultComboBoxModel<CharsetEncodingItem> model = new DefaultComboBoxModel<CharsetEncodingItem>();
        Charset defaultEncoding = Charset.defaultCharset();
        Charset utf8 = Charset.forName("UTF-8");
        model.addElement(new CharsetEncodingItem("UTF 8", utf8));
        model.addElement(new CharsetEncodingItem("Platform Specific (" + defaultEncoding.name() + ")", defaultEncoding));
        model.addElement(new CharsetEncodingItem("UTF 8 with BOM", utf8, true));
        return model;
    }

    public boolean isApproved() {
        return this.approved;
    }

    private final class ProfileWrapper {
        private ProfileForm profile;
        private boolean selected;

        ProfileWrapper(ProfileForm profile) {
            this.profile = profile;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            ExportDialog.this.enableGenerateButton();
        }

        public boolean isSelected() {
            return this.selected;
        }

        public ProfileForm getProfile() {
            return this.profile;
        }
    }

    private final class CheckBoxEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 8023412072260282004L;
        private ProfileWrapper profile;

        public CheckBoxEditor() {
            super(new JCheckBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.profile = (ProfileWrapper)value;
            JCheckBox checkBox = (JCheckBox)this.getComponent();
            checkBox.setText(this.profile.getProfile().getName());
            checkBox.setSelected(this.profile.isSelected());
            checkBox.setOpaque(false);
            return checkBox;
        }

        @Override
        public Object getCellEditorValue() {
            this.profile.setSelected(((JCheckBox)this.getComponent()).isSelected());
            return this.profile;
        }
    }

    private final class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -4078523535790396904L;

        private CheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ProfileWrapper profile = (ProfileWrapper)value;
            this.setSelected(profile.isSelected());
            this.setText(profile.getProfile().getName());
            this.setOpaque(false);
            boolean enabled = ((ProfileWrapper)ExportDialog.this.profilesRowData.get(row)).getProfile().getProfile().getState().isReportable();
            this.setEnabled(enabled);
            return this;
        }
    }

    class CharsetEncodingItem {
        private final String label;
        private final Charset charset;
        private final boolean bom;

        public CharsetEncodingItem(String label, Charset charset) {
            this.label = label;
            this.charset = charset;
            this.bom = false;
        }

        public CharsetEncodingItem(String label, Charset charset, boolean bom) {
            this.label = label;
            this.charset = charset;
            this.bom = bom;
        }

        public String getLabel() {
            return this.label;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public boolean isBom() {
            return this.bom;
        }

        public String toString() {
            return this.label;
        }
    }
}

