/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.export;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FilenameUtils;

public class ExportFileChooser
extends JFileChooser {
    private static final String CSV_EXT = "csv";
    private static final long serialVersionUID = -3733290468455212962L;
    private FileNameExtensionFilter csvFilter;

    @Override
    protected void setup(FileSystemView view) {
        super.setup(view);
        this.setAcceptAllFileFilterUsed(true);
        this.csvFilter = new FileNameExtensionFilter("Comma separated values (*.csv)", CSV_EXT);
        this.addChoosableFileFilter(this.csvFilter);
    }

    @Override
    public void approveSelection() {
        String filename;
        String ext;
        int confirm = 0;
        if (!this.getSelectedFile().exists() && this.getFileFilter().equals(this.csvFilter) && !CSV_EXT.equals(ext = FilenameUtils.getExtension((String)(filename = this.getSelectedFile().getName())))) {
            this.setSelectedFile(new File(this.getSelectedFile().getParentFile(), filename + "." + CSV_EXT));
        }
        if (this.getSelectedFile().exists()) {
            confirm = JOptionPane.showConfirmDialog(this, "The file you have selected already exists. Do you wish to overwrite it?", "File exists warning", 1, 2);
        }
        if (confirm == 0) {
            super.approveSelection();
        } else if (confirm == 2) {
            super.cancelSelection();
        }
    }
}

