/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.filechooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.util.NbBundle;
import uk.gov.nationalarchives.droid.gui.filechooser.ResourceDialogUtil;
import uk.gov.nationalarchives.droid.gui.filechooser.ResourceTreeWillExpandListener;
import uk.gov.nationalarchives.droid.util.FileUtil;

public class ResourceSelectorDialog
extends JDialog {
    private static final int FILE_COLUMN_INDEX = 0;
    private static final int SIZE_COLUMN_INDEX = 1;
    private static final int DATE_COLUMN_INDEX = 2;
    private static final int WIDE_COLUMN = 200;
    private static final int NARROW_COLUMN = 100;
    private static final long serialVersionUID = -8906890136444606083L;
    private static final char QUOTE = '\"';
    private static final Object[] COLUMN_NAMES = new Object[]{"Name", "Size", "Last modified"};
    private static final Class<?>[] TYPES = new Class[]{File.class, Long.class, Date.class};
    private FileSystemView fsv = FileSystemView.getFileSystemView();
    private List<File> selectedFiles = new ArrayList<File>();
    private int response = 1;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JButton okButton;
    private JTextField selectedFilesTextBox;
    private JCheckBox subfoldersCheckBox;
    private JTable table;
    private JTree tree;

    public ResourceSelectorDialog(Window parent) {
        super(parent);
        this.initComponents();
        this.initTree();
        this.initTable();
        this.pack();
    }

    public int showDialog(Component parent) {
        this.setLocationRelativeTo(parent);
        this.response = 1;
        this.setVisible(true);
        return this.response;
    }

    public int getResponse() {
        return this.response;
    }

    public boolean isSelectionRecursive() {
        return this.subfoldersCheckBox.isSelected();
    }

    public List<File> getSelectedFiles() {
        return this.selectedFiles;
    }

    private DefaultTreeModel getTreeModel() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(new File("File System"), true);
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode, true);
        return treeModel;
    }

    private void initTree() {
        this.tree.setCellRenderer(new FileTreeCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
        File[] roots = this.fsv.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            File[] children;
            File rootFile = roots[i];
            boolean rootAllowsChildren = rootFile.isDirectory();
            DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(rootFile, rootAllowsChildren);
            if (rootAllowsChildren) {
                rootNode.add(newChild);
            }
            if ((children = rootFile.listFiles()) != null) {
                List<File> sortedChildren = ResourceDialogUtil.sortFiles(children);
                for (File child : sortedChildren) {
                    File[] listFiles = child.listFiles();
                    if (!child.isDirectory()) continue;
                    boolean allowsChildren = listFiles != null && listFiles.length > 0;
                    DefaultMutableTreeNode subFolder = new DefaultMutableTreeNode(child, allowsChildren);
                    newChild.add(subFolder);
                }
            }
            this.tree.expandPath(new TreePath(newChild.getPath()));
        }
        treeModel.nodeStructureChanged(rootNode);
        this.tree.addTreeWillExpandListener(new ResourceTreeWillExpandListener());
        this.tree.addTreeSelectionListener(new FileTreeSelectionListener());
    }

    private void initTable() {
        this.table.setDefaultRenderer(File.class, new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object value) {
                File f = (File)value;
                this.setIcon(ResourceSelectorDialog.this.fsv.getSystemIcon(f));
                this.setText(ResourceSelectorDialog.this.fsv.getSystemDisplayName(f));
            }
        });
        this.table.setDefaultRenderer(Long.class, new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object value) {
                this.setHorizontalAlignment(4);
                this.setText(value == null ? "" : FileUtil.formatFileSize((long)((Long)value), (int)1));
            }
        });
        this.table.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object value) {
                this.setText(value == null ? "" : DateFormat.getDateTimeInstance().format(value));
            }
        });
        this.table.addMouseListener(new DoubleClickMouseAdapter());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int[] selectedRows = ResourceSelectorDialog.this.table.getSelectedRows();
                    ResourceSelectorDialog.this.selectedFiles.clear();
                    for (int i : selectedRows) {
                        ResourceSelectorDialog.this.selectedFiles.add((File)ResourceSelectorDialog.this.table.getValueAt(i, 0));
                    }
                    ResourceSelectorDialog.this.selectedFilesTextBox.setText(ResourceSelectorDialog.this.toText(ResourceSelectorDialog.this.selectedFiles));
                }
            }
        });
        this.table.setAutoResizeMode(2);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && ResourceSelectorDialog.this.table.getSelectedColumnCount() == 1) {
                    ResourceSelectorDialog.this.exploreTableFolder(ResourceSelectorDialog.this.table.getSelectedRow());
                }
            }
        });
    }

    private String toText(List<File> files) {
        StringBuilder sb = new StringBuilder();
        for (File f : files) {
            sb.append('\"' + this.fsv.getSystemDisplayName(f) + '\"' + ' ');
        }
        return sb.toString();
    }

    private void exploreTableFolder(int rowIndex) {
        File f = (File)this.table.getValueAt(rowIndex, 0);
        if (f.isDirectory()) {
            TreePath selectionPath = this.tree.getSelectionPath();
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            Enumeration<TreeNode> e = treeNode.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                if (!n.getUserObject().equals(f)) continue;
                TreePath path = new TreePath(n.getPath());
                this.tree.expandPath(path);
                this.tree.setSelectionPath(path);
                this.tree.scrollPathToVisible(path);
                break;
            }
        }
    }

    private TableModel updateTable(File[] contents) {
        DefaultTableModel tableModel = new DefaultTableModel(COLUMN_NAMES, 0){
            private static final long serialVersionUID = -1940634018074783780L;

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return TYPES[columnIndex];
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        for (File f : contents) {
            tableModel.addRow(new Object[]{f, f.isDirectory() ? null : Long.valueOf(f.length()), f.lastModified() == 0L ? null : new Date(f.lastModified())});
        }
        return tableModel;
    }

    private void initColumnModel() {
        TableColumnModel columnModel = this.table.getColumnModel();
        TableColumn fileColumn = columnModel.getColumn(0);
        fileColumn.setPreferredWidth(200);
        fileColumn.setHeaderValue(NbBundle.getMessage(ResourceSelectorDialog.class, (String)"ResourceSelector.table.columnModel.title0"));
        columnModel.getColumn(1).setPreferredWidth(100);
        columnModel.getColumn(1).setHeaderValue(NbBundle.getMessage(ResourceSelectorDialog.class, (String)"ResourceSelector.table.columnModel.title1"));
        columnModel.getColumn(2).setPreferredWidth(200);
        columnModel.getColumn(2).setHeaderValue(NbBundle.getMessage(ResourceSelectorDialog.class, (String)"ResourceSelector.table.columnModel.title3"));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.table = new JTable();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.jPanel4 = new JPanel();
        this.selectedFilesTextBox = new JTextField();
        this.subfoldersCheckBox = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle(NbBundle.getMessage(ResourceSelectorDialog.class, (String)"ResourceSelectorDialog.title"));
        this.jSplitPane1.setDividerLocation(200);
        this.table.setModel(new DefaultTableModel());
        this.table.setFillsViewportHeight(true);
        this.table.setIntercellSpacing(new Dimension(4, 1));
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.jScrollPane2.setViewportView(this.table);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.jPanel3.setBorder(new SoftBevelBorder(0));
        this.jLabel1.setText(NbBundle.getMessage(ResourceSelectorDialog.class, (String)"ResourceSelector.jLabel1.text"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 193, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1, -1, 14, Short.MAX_VALUE).addContainerGap()));
        this.tree.setModel(this.getTreeModel());
        this.tree.setLargeModel(true);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.jScrollPane1.setViewportView(this.tree);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 199, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanel3, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1)));
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 717, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 352, Short.MAX_VALUE).addContainerGap()));
        this.selectedFilesTextBox.setEditable(false);
        this.selectedFilesTextBox.setText(NbBundle.getMessage(ResourceSelectorDialog.class, (String)"ResourceSelector.jTextField1.text"));
        this.subfoldersCheckBox.setSelected(true);
        this.subfoldersCheckBox.setText(NbBundle.getMessage(ResourceSelectorDialog.class, (String)"ResourceSelector.jCheckBox1.text"));
        this.jLabel2.setText(NbBundle.getMessage(ResourceSelectorDialog.class, (String)"ResourceSelector.jLabel2.text"));
        this.okButton.setText(NbBundle.getMessage(ResourceSelectorDialog.class, (String)"ResourceSelector.okButton.text"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResourceSelectorDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(NbBundle.getMessage(ResourceSelectorDialog.class, (String)"ResourceSelector.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResourceSelectorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.subfoldersCheckBox, -1, 522, Short.MAX_VALUE).addComponent(this.selectedFilesTextBox, -1, 522, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.cancelButton).addComponent(this.okButton, -2, 68, -2)).addContainerGap()));
        jPanel4Layout.linkSize(0, this.cancelButton, this.okButton);
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jLabel2)).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.selectedFilesTextBox, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cancelButton).addComponent(this.subfoldersCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.linkSize(1, this.cancelButton, this.okButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2)));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.response = 0;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private class FileTreeSelectionListener
    implements TreeSelectionListener {
        private FileTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath treePath = e.getNewLeadSelectionPath();
            if (treePath != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                File f = (File)node.getUserObject();
                File[] listFiles = f.listFiles();
                if (listFiles != null) {
                    ResourceSelectorDialog.this.table.setModel(ResourceSelectorDialog.this.updateTable(listFiles));
                    TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(ResourceSelectorDialog.this.table.getModel());
                    sorter.setComparator(0, new Comparator<File>(){

                        @Override
                        public int compare(File f1, File f2) {
                            Boolean f1Dir = f1.isDirectory();
                            Boolean f2Dir = f2.isDirectory();
                            int comp = f2Dir.compareTo(f1Dir);
                            if (comp == 0) {
                                comp = f1.getName().compareToIgnoreCase(f2.getName());
                            }
                            return comp;
                        }
                    });
                    ResourceSelectorDialog.this.table.setRowSorter(sorter);
                    sorter.sort();
                    sorter.toggleSortOrder(0);
                    ResourceSelectorDialog.this.initColumnModel();
                    ResourceSelectorDialog.this.tree.expandPath(treePath);
                } else {
                    ResourceSelectorDialog.this.table.setModel(new DefaultTableModel());
                }
                ResourceSelectorDialog.this.selectedFiles.clear();
                ResourceSelectorDialog.this.selectedFiles.add(f);
                ResourceSelectorDialog.this.selectedFilesTextBox.setText('\"' + ResourceSelectorDialog.this.fsv.getSystemDisplayName(f) + '\"');
            }
        }
    }

    private class FileTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -971847725978939749L;

        private FileTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree parentTree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            File f = (File)((DefaultMutableTreeNode)value).getUserObject();
            if (f.exists()) {
                this.setIcon(ResourceSelectorDialog.this.fsv.getSystemIcon(f));
                String systemDisplayName = ResourceSelectorDialog.this.fsv.getSystemDisplayName(f);
                this.setText(systemDisplayName.isEmpty() ? f.getPath() : systemDisplayName);
                if (sel) {
                    this.setForeground(this.getTextSelectionColor());
                } else {
                    this.setForeground(this.getTextNonSelectionColor());
                }
                this.selected = sel;
                return this;
            }
            return super.getTreeCellRendererComponent(parentTree, value, sel, expanded, leaf, row, hasFocus);
        }
    }

    private class DoubleClickMouseAdapter
    extends MouseAdapter {
        private DoubleClickMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            int clickedRow;
            if (event.getClickCount() == 2 && (clickedRow = ResourceSelectorDialog.this.table.rowAtPoint(event.getPoint())) != -1) {
                ResourceSelectorDialog.this.exploreTableFolder(clickedRow);
            }
        }
    }
}

