/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.filter;

import java.awt.Color;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.util.NbBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.gui.filter.domain.FilterValidationException;

public class DatePicker
extends JPanel {
    private static final String INVALID_DATE = "Invalid date";
    private static final int MONTH_END_INDEX = 5;
    private static final int MONTH_START_INDEX = 3;
    private static final long serialVersionUID = -4884183026736825056L;
    private static final String DATE_DELIMITER = "/";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JComboBox dayComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JComboBox monthComboBox;
    private JTextField yearTextBox;

    public DatePicker() {
        int i;
        this.initComponents();
        GregorianCalendar cal = new GregorianCalendar();
        int minDay = cal.getMinimum(5);
        int maxDay = cal.getMaximum(5);
        int minMonth = cal.getMinimum(2);
        int maxMonth = cal.getMaximum(2);
        ArrayList<Integer> days = new ArrayList<Integer>();
        ArrayList<Integer> months = new ArrayList<Integer>();
        for (i = minDay; i <= maxDay; ++i) {
            days.add(i);
        }
        for (i = minMonth; i <= maxMonth; ++i) {
            months.add(i + 1);
        }
        this.dayComboBox.setModel(new DefaultComboBoxModel<Object>(days.toArray()));
        this.monthComboBox.setModel(new DefaultComboBoxModel<Object>(months.toArray()));
        this.jLabel1.setText("Day:");
        this.jLabel2.setText("Month:");
        this.jLabel3.setText("Year:");
    }

    private void initComponents() {
        this.dayComboBox = new JComboBox();
        this.monthComboBox = new JComboBox();
        this.yearTextBox = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.dayComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.monthComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.yearTextBox.setText(NbBundle.getMessage(DatePicker.class, (String)"DatePicker.yearTextBox.text"));
        this.jLabel1.setText(NbBundle.getMessage(DatePicker.class, (String)"DatePicker.jLabel1.text"));
        this.jLabel2.setText(NbBundle.getMessage(DatePicker.class, (String)"DatePicker.jLabel2.text"));
        this.jLabel3.setText(NbBundle.getMessage(DatePicker.class, (String)"DatePicker.jLabel3.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dayComboBox, -2, -1, -2).addGap(15, 15, 15).addComponent(this.jLabel2).addGap(12, 12, 12).addComponent(this.monthComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.yearTextBox, -1, 108, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dayComboBox, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.monthComboBox, -2, -1, -2).addComponent(this.yearTextBox, -2, -1, -2)));
    }

    public void setRedBorderToYearBox() {
        this.yearTextBox.setBorder(BorderFactory.createLineBorder(Color.red));
        this.repaint();
    }

    public void clearRedBorderToYearBox() {
        this.yearTextBox.setBorder(null);
        this.repaint();
    }

    public void setRedBorderToMonthBox() {
        this.monthComboBox.setBorder(BorderFactory.createLineBorder(Color.red));
        this.repaint();
    }

    public void clearRedBorderToMonthBox() {
        this.monthComboBox.setBorder(null);
        this.repaint();
    }

    public void setRedBorderToDayBox() {
        this.dayComboBox.setBorder(BorderFactory.createLineBorder(Color.red));
        this.repaint();
    }

    public void clearRedBorderToDayBox() {
        this.dayComboBox.setBorder(null);
        this.repaint();
    }

    public void paintRedBoxToComponents() {
        this.yearTextBox.setBorder(BorderFactory.createLineBorder(Color.red));
        this.monthComboBox.setBorder(BorderFactory.createLineBorder(Color.red));
        this.dayComboBox.setBorder(BorderFactory.createLineBorder(Color.red));
        this.repaint();
    }

    public void clearRedBoxToComponents() {
        this.yearTextBox.setBorder(null);
        this.monthComboBox.setBorder(null);
        this.dayComboBox.setBorder(BorderFactory.createLineBorder(Color.red));
        this.repaint();
    }

    public String getDateString() throws FilterValidationException {
        try {
            DateMidnight date = new DateMidnight(Integer.valueOf(this.yearTextBox.getText()).intValue(), ((Integer)this.monthComboBox.getSelectedItem()).intValue(), ((Integer)this.dayComboBox.getSelectedItem()).intValue());
            return ISODateTimeFormat.date().print((ReadableInstant)date);
        }
        catch (IllegalFieldValueException e) {
            throw new FilterValidationException(INVALID_DATE);
        }
        catch (NumberFormatException e) {
            throw new FilterValidationException(INVALID_DATE);
        }
    }

    public void setDateCombos(String contextDate) {
        DateTime date = ISODateTimeFormat.date().parseDateTime(contextDate);
        this.dayComboBox.getModel().setSelectedItem(date.getDayOfMonth());
        this.monthComboBox.getModel().setSelectedItem(date.getMonthOfYear());
        this.yearTextBox.setText(String.valueOf(date.getYear()));
    }
}

