/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.filter;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.xml.bind.JAXBException;
import org.openide.util.NbBundle;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionFieldEnum;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionOperator;
import uk.gov.nationalarchives.droid.gui.DroidUIContext;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.gui.action.ApplyFilterToTreeTableAction;
import uk.gov.nationalarchives.droid.gui.filter.DatePicker;
import uk.gov.nationalarchives.droid.gui.filter.FilterTable;
import uk.gov.nationalarchives.droid.gui.filter.JComponentCellEditor;
import uk.gov.nationalarchives.droid.gui.filter.JComponentCellRenderer;
import uk.gov.nationalarchives.droid.gui.filter.TextBoxAndButton;
import uk.gov.nationalarchives.droid.gui.filter.action.InitialiseFilterAction;
import uk.gov.nationalarchives.droid.gui.filter.action.LoadFilterAction;
import uk.gov.nationalarchives.droid.gui.filter.domain.DummyMetadata;
import uk.gov.nationalarchives.droid.gui.filter.domain.ExtensionMismatchMetadata;
import uk.gov.nationalarchives.droid.gui.filter.domain.FilterDomain;
import uk.gov.nationalarchives.droid.gui.filter.domain.FilterValidationException;
import uk.gov.nationalarchives.droid.gui.filter.domain.GenericMetadata;
import uk.gov.nationalarchives.droid.gui.filter.domain.LastModifiedDateMetadata;
import uk.gov.nationalarchives.droid.profile.FilterCriterionImpl;
import uk.gov.nationalarchives.droid.profile.FilterImpl;
import uk.gov.nationalarchives.droid.profile.JaxbFilterSpecDao;
import uk.gov.nationalarchives.droid.profile.ProfileManager;

public class FilterDialog
extends JDialog {
    private static final int ROW_HEIGHT = 23;
    private static final String REMOVE = "Remove";
    private static final int COL_0_WIDTH = 150;
    private static final int COL_1_WIDTH = 150;
    private static final int COL_3_WIDTH = 90;
    private static final int COL_2_WIDTH = 375;
    private static final int COL_0 = 0;
    private static final int COL_1 = 1;
    private static final int COL_2 = 2;
    private static final int COL_3 = 3;
    private static final long serialVersionUID = 5181319919824269596L;
    private DefaultTableModel tableModel = new DefaultTableModel();
    private FilterDomain filterDomain = new FilterDomain();
    private FilterImpl filterContext;
    private FilterImpl tempFilterContext;
    private DroidUIContext droidContext;
    private ProfileManager profileManager;
    private JComboBox metaDataCombobox;
    private JComboBox operationCombobox;
    private DefaultComboBoxModel operationComboboxModel;
    private boolean filterPredicatesLoading;
    private JFileChooser filterFileChooser;
    private JButton LoadFilterButton;
    private JButton SaveFilterButton;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JCheckBox filterEnabledCheckbox;
    private JTable filterTable;
    private JButton jButtonApply;
    private JButton jButtonCancle;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JRadioButton narrowResultRadioButton;
    private JRadioButton widenResultsRadioButton;

    public FilterDialog(Frame parent, boolean modal, FilterImpl filterContext, DroidUIContext droidContext, ProfileManager profileManager, JFileChooser filterFileChooser) {
        super(parent, modal);
        this.filterContext = filterContext;
        this.droidContext = droidContext;
        this.profileManager = profileManager;
        this.filterFileChooser = filterFileChooser;
        this.intialiseFilter();
        this.initComponents();
        this.myInitComponents();
        this.tempFilterContext = (FilterImpl)filterContext.clone();
        this.loadFilter();
        this.setLocationRelativeTo(parent);
    }

    public FilterDomain getFilter() {
        return this.filterDomain;
    }

    public void setFilter(FilterDomain filter) {
        this.filterDomain = filter;
    }

    public FilterImpl getFilterContext() {
        return this.filterContext;
    }

    private void loadFilter() {
        if (this.isFilterPrevioudlyLoaded()) {
            this.filterPredicatesLoading = true;
            this.filterEnabledCheckbox.setSelected(this.filterContext.isEnabled());
            this.setFilterMode();
            LoadFilterAction loadFilterAction = new LoadFilterAction();
            loadFilterAction.loadFilter(this);
            this.filterPredicatesLoading = false;
        }
    }

    private void setFilterMode() {
        if (this.filterContext.isNarrowed()) {
            this.narrowResultRadioButton.setSelected(true);
        } else {
            this.widenResultsRadioButton.setSelected(true);
        }
    }

    private boolean isFilterPrevioudlyLoaded() {
        return this.filterContext.hasCriteria();
    }

    private void intialiseFilter() {
        String profileId = this.droidContext.getSelectedProfile().getProfile().getUuid();
        InitialiseFilterAction initialiseFilterAction = new InitialiseFilterAction();
        initialiseFilterAction.initialiseFilter(profileId, this.profileManager, this.filterDomain);
    }

    public Object[] getRowForTable() {
        TextBoxAndButton component = new TextBoxAndButton(this);
        ((Component)component).hide();
        this.metaDataCombobox = new JComboBox<CriterionFieldEnum>(this.filterDomain.getMetaDataNames());
        this.metaDataCombobox.setRenderer(new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String displayText = value == null ? "<Please select...>" : value.toString();
                return super.getListCellRendererComponent((JList<?>)list, displayText, index, isSelected, cellHasFocus);
            }
        });
        this.operationCombobox = new JComboBox();
        this.operationComboboxModel = new DefaultComboBoxModel();
        this.operationCombobox.setModel(this.operationComboboxModel);
        this.metaDataCombobox.addItemListener(new MetaDataComboItemListner());
        this.operationCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !FilterDialog.this.filterPredicatesLoading) {
                    FilterCriterionImpl filterCriterion = FilterDialog.this.filterContext.getFilterCriterion(FilterDialog.this.filterTable.getSelectedRow());
                    JComboBox sourceCombo = (JComboBox)e.getSource();
                    filterCriterion.setOperator((CriterionOperator)sourceCombo.getSelectedItem());
                }
            }
        });
        JButton jButton2 = new JButton(REMOVE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterDialog.this.tableModel.getRowCount() > 1 && FilterDialog.this.filterTable.getSelectedRow() + 1 != FilterDialog.this.tableModel.getRowCount()) {
                    int size = FilterDialog.this.filterContext.getNumberOfFilterCriterion();
                    FilterDialog.this.filterContext.removeFilterCriterion(FilterDialog.this.filterTable.getSelectedRow());
                    for (int k = FilterDialog.this.filterTable.getSelectedRow() + 1; k < size; ++k) {
                        FilterDialog.this.filterContext.getFilterCriteriaMap().put(k - 1, (FilterCriterionImpl)FilterDialog.this.filterContext.getFilterCriteriaMap().get(k));
                    }
                    FilterDialog.this.filterContext.removeFilterCriterion(size - 1);
                    FilterDialog.this.tableModel.removeRow(FilterDialog.this.filterTable.getSelectedRow());
                    FilterDialog.this.tableModel.fireTableRowsDeleted(FilterDialog.this.filterTable.getSelectedRow(), FilterDialog.this.filterTable.getSelectedRow());
                    FilterDialog.this.filterTable.revalidate();
                    FilterDialog.this.initColumnSizes(FilterDialog.this.filterTable);
                }
            }
        });
        Object[] data = new Object[]{this.metaDataCombobox, this.operationCombobox, component, jButton2};
        this.metaDataCombobox.setMaximumRowCount(this.filterDomain.getMetaDataNames().length);
        return data;
    }

    private void myInitComponents() {
        this.filterTable = new FilterTable();
        this.filterTable.setRowHeight(23);
        this.filterTable.setDefaultRenderer(JComponent.class, new JComponentCellRenderer());
        this.filterTable.setDefaultEditor(JComponent.class, new JComponentCellEditor());
        this.filterTable.setSelectionMode(0);
        this.tableModel.addColumn("Field");
        this.tableModel.addColumn("Operation");
        this.tableModel.addColumn("Values");
        this.tableModel.addColumn(REMOVE);
        this.tableModel.insertRow(0, this.getRowForTable());
        this.filterTable.setModel(this.tableModel);
        this.initColumnSizes(this.filterTable);
        this.jScrollPane1.setViewportView(this.filterTable);
        this.buttonGroup1.add(this.widenResultsRadioButton);
        this.buttonGroup1.add(this.narrowResultRadioButton);
        this.narrowResultRadioButton.setSelected(true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.widenResultsRadioButton = new JRadioButton();
        this.narrowResultRadioButton = new JRadioButton();
        this.jPanel5 = new JPanel();
        this.filterEnabledCheckbox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jButtonCancle = new JButton();
        this.jButtonApply = new JButton();
        this.LoadFilterButton = new JButton();
        this.SaveFilterButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.filterTable = new JTable();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(FilterDialog.class, (String)"FilterDialog.title"));
        this.widenResultsRadioButton.setText(NbBundle.getMessage(FilterDialog.class, (String)"FilterDialog.widenResultsRadioButton.text"));
        this.narrowResultRadioButton.setText(NbBundle.getMessage(FilterDialog.class, (String)"FilterDialog.narrowResultRadioButton.text"));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.narrowResultRadioButton).addGap(18, 18, 18).addComponent(this.widenResultsRadioButton).addContainerGap(77, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.narrowResultRadioButton).addComponent(this.widenResultsRadioButton))));
        this.filterEnabledCheckbox.setSelected(true);
        this.filterEnabledCheckbox.setText(NbBundle.getMessage(FilterDialog.class, (String)"FilterDialog.filterEnabledCheckbox.text"));
        this.filterEnabledCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.filterEnabledCheckboxActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.filterEnabledCheckbox).addContainerGap(266, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.filterEnabledCheckbox)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel5, -2, -1, -2).addContainerGap(108, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, -2, -1, -2)).addContainerGap()));
        this.jButtonCancle.setText(NbBundle.getMessage(FilterDialog.class, (String)"FilterDialog.jButtonCancle.text"));
        this.jButtonCancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.jButtonCancleActionPerformed(evt);
            }
        });
        this.jButtonApply.setText(NbBundle.getMessage(FilterDialog.class, (String)"FilterDialog.jButtonApply.text"));
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.jButtonApplyActionPerformed(evt);
            }
        });
        this.LoadFilterButton.setText(NbBundle.getMessage(FilterDialog.class, (String)"FilterDialog.LoadFilterButton.text"));
        this.LoadFilterButton.setToolTipText(NbBundle.getMessage(FilterDialog.class, (String)"FilterDialog.LoadFilterButton.toolTipText"));
        this.LoadFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.LoadFilterButtonActionPerformed(evt);
            }
        });
        this.SaveFilterButton.setText(NbBundle.getMessage(FilterDialog.class, (String)"FilterDialog.SaveFilterButton.text"));
        this.SaveFilterButton.setToolTipText(NbBundle.getMessage(FilterDialog.class, (String)"FilterDialog.SaveFilterButton.toolTipText"));
        this.SaveFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterDialog.this.SaveFilterButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.LoadFilterButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.SaveFilterButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 228, Short.MAX_VALUE).addComponent(this.jButtonApply, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancle, -2, 111, -2).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonApply, this.jButtonCancle);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LoadFilterButton).addComponent(this.SaveFilterButton).addComponent(this.jButtonCancle).addComponent(this.jButtonApply)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonApply, this.jButtonCancle);
        this.filterTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.filterTable);
        this.filterTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(FilterDialog.class, (String)"FilterDialog.jTable1.columnModel.title0"));
        this.filterTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(FilterDialog.class, (String)"FilterDialog.jTable1.columnModel.title1"));
        this.filterTable.getColumnModel().getColumn(2).setHeaderValue(NbBundle.getMessage(FilterDialog.class, (String)"FilterDialog.jTable1.columnModel.title2"));
        this.filterTable.getColumnModel().getColumn(3).setHeaderValue(NbBundle.getMessage(FilterDialog.class, (String)"FilterDialog.jTable1.columnModel.title3"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel2, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 656, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 200, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void LoadFilterButtonActionPerformed(ActionEvent evt) {
        int result = this.filterFileChooser.showOpenDialog(this);
        if (result == 0) {
            try {
                JaxbFilterSpecDao reader = new JaxbFilterSpecDao();
                try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(this.filterFileChooser.getSelectedFile().toPath(), new OpenOption[0]));){
                    this.filterContext = reader.loadFilter((InputStream)in);
                }
                this.loadFilter();
            }
            catch (IOException | JAXBException e) {
                JOptionPane.showMessageDialog(this, "There was a problem loading the filter.", "Filter warning", 0);
            }
        }
    }

    private void SaveFilterButtonActionPerformed(ActionEvent evt) {
        int result;
        if (this.applyValuesToContext() && (result = this.filterFileChooser.showSaveDialog(this)) == 0) {
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(this.filterFileChooser.getSelectedFile().toPath(), new OpenOption[0]));){
                JaxbFilterSpecDao writer = new JaxbFilterSpecDao();
                writer.saveFilter(this.filterContext, (OutputStream)out);
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(this, "There was a problem saving the filter.", "Filter warning", 0);
            }
            catch (JAXBException e) {
                JOptionPane.showMessageDialog(this, "There was a problem saving the filter.", "Filter warning", 0);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "There was a problem saving the filter.", "Filter warning", 0);
            }
        }
    }

    private void filterEnabledCheckboxActionPerformed(ActionEvent evt) {
    }

    private void jButtonCancleActionPerformed(ActionEvent evt) {
        this.droidContext.getSelectedProfile().getProfile().setFilter(this.tempFilterContext);
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        this.filterContext.setEnabled(this.filterEnabledCheckbox.isSelected());
        this.filterContext.setNarrowed(this.narrowResultRadioButton.isSelected());
        this.droidContext.getSelectedProfile().getProfile().setFilter(this.filterContext);
        if (this.applyValuesToContext()) {
            this.getDroidContext().getSelectedProfile().getProfile().setDirty(true);
            ProfileForm profileToFilter = this.getDroidContext().getSelectedProfile();
            ApplyFilterToTreeTableAction applyFilterToTreeAction = new ApplyFilterToTreeTableAction(profileToFilter, this.getProfileManager());
            applyFilterToTreeAction.applyFilter();
            this.dispatchEvent(new WindowEvent(this, 201));
        }
    }

    private boolean applyValuesToContext() {
        DefaultTableModel tModel = (DefaultTableModel)this.getFilterTable().getModel();
        ArrayList<String> errorStrings = new ArrayList<String>();
        for (int i = 0; i < tModel.getRowCount() - 1; ++i) {
            JComboBox comboBox1 = (JComboBox)tModel.getValueAt(i, 0);
            CriterionFieldEnum firstComboBoxSelectedItem = (CriterionFieldEnum)comboBox1.getSelectedItem();
            Component componentAtThirdRow = (Component)tModel.getValueAt(i, 2);
            String freeTextAtRow = null;
            try {
                if (componentAtThirdRow instanceof TextBoxAndButton) {
                    freeTextAtRow = ((TextBoxAndButton)componentAtThirdRow).getTextField().getText();
                } else if (componentAtThirdRow instanceof DatePicker) {
                    freeTextAtRow = ((DatePicker)componentAtThirdRow).getDateString();
                } else if (componentAtThirdRow instanceof JComboBox) {
                    freeTextAtRow = ((JComboBox)componentAtThirdRow).getSelectedItem().toString();
                } else {
                    throw new RuntimeException("Fatal error");
                }
                GenericMetadata metadata = this.getFilterDomain().getMetaDataFromFieldType(firstComboBoxSelectedItem);
                metadata.validate(freeTextAtRow);
            }
            catch (FilterValidationException filterValidationException) {
                errorStrings.add(filterValidationException.getMessage());
            }
            FilterCriterionImpl filterCriteria = this.getFilterContext().getFilterCriterion(i);
            filterCriteria.setValueFreeText(freeTextAtRow);
        }
        if (errorStrings.size() > 0) {
            JOptionPane.showMessageDialog(this, errorStrings.toArray());
            return false;
        }
        return true;
    }

    private void initColumnSizes(JTable table) {
        TableColumn col = table.getColumnModel().getColumn(0);
        col.setPreferredWidth(150);
        col = table.getColumnModel().getColumn(1);
        col.setPreferredWidth(150);
        col = table.getColumnModel().getColumn(2);
        col.setPreferredWidth(375);
        col = table.getColumnModel().getColumn(3);
        col.setPreferredWidth(90);
    }

    public FilterDomain getFilterDomain() {
        return this.filterDomain;
    }

    public DroidUIContext getDroidContext() {
        return this.droidContext;
    }

    public JTable getFilterTable() {
        return this.filterTable;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    private class MetaDataComboItemListner
    implements ItemListener {
        private MetaDataComboItemListner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!FilterDialog.this.filterPredicatesLoading) {
                CriterionFieldEnum deSelectedItem = null;
                if (e.getStateChange() == 2) {
                    deSelectedItem = (CriterionFieldEnum)e.getItem();
                }
                JComponent comp = null;
                int selectedRow = FilterDialog.this.filterTable.getSelectedRow();
                JComboBox sourceCombo = (JComboBox)e.getSource();
                CriterionFieldEnum selectedItem = (CriterionFieldEnum)sourceCombo.getSelectedItem();
                if (selectedItem != null) {
                    GenericMetadata metadata = FilterDialog.this.filterDomain.getMetaDataFromFieldType(selectedItem);
                    comp = metadata instanceof LastModifiedDateMetadata ? new DatePicker() : (metadata instanceof ExtensionMismatchMetadata ? new JComboBox() : new TextBoxAndButton(FilterDialog.this));
                    FilterDialog.this.tableModel.setValueAt(comp, FilterDialog.this.filterTable.getSelectedRow(), 2);
                    if (e.getStateChange() == 1) {
                        if (FilterDialog.this.tableModel.getRowCount() == selectedRow + 1) {
                            FilterDialog.this.tableModel.addRow(FilterDialog.this.getRowForTable());
                            FilterDialog.this.filterTable.revalidate();
                        }
                        JComboBox comboBox = (JComboBox)FilterDialog.this.tableModel.getValueAt(selectedRow, 1);
                        FilterDialog.this.operationComboboxModel = (DefaultComboBoxModel)comboBox.getModel();
                        FilterCriterionImpl newCriteria = new FilterCriterionImpl();
                        newCriteria.setRowNumber(FilterDialog.this.filterTable.getSelectedRow());
                        newCriteria.setField(metadata.getField());
                        FilterDialog.this.filterContext.addFilterCiterion(newCriteria, FilterDialog.this.filterTable.getSelectedRow());
                        this.applyMetadaUILogic(comp, metadata);
                        FilterDialog.this.operationComboboxModel.removeAllElements();
                        for (CriterionOperator metaDataOp : metadata.getOperationList()) {
                            FilterDialog.this.operationComboboxModel.addElement(metaDataOp);
                        }
                        if (comp instanceof TextBoxAndButton) {
                            ((TextBoxAndButton)comp).setType(metadata, FilterDialog.this.filterContext.getFilterCriterion(FilterDialog.this.filterTable.getSelectedRow()));
                        }
                        if (comp instanceof JComboBox) {
                            JComboBox combo = (JComboBox)comp;
                            combo.addItem("true");
                            combo.addItem("false");
                        }
                        FilterDialog.this.filterTable.repaint();
                    }
                } else {
                    GenericMetadata metadata = FilterDialog.this.getFilterDomain().getMetaDataFromFieldType(deSelectedItem);
                    sourceCombo.getModel().setSelectedItem(metadata.getField());
                }
            }
        }

        private void applyMetadaUILogic(Component comp, GenericMetadata metadata) {
            if (metadata.isFreeText()) {
                if (comp instanceof TextBoxAndButton) {
                    ((TextBoxAndButton)comp).getButton().hide();
                    ((TextBoxAndButton)comp).getTextField().show();
                }
            } else {
                if (comp instanceof TextBoxAndButton) {
                    ((TextBoxAndButton)comp).getTextField().disable();
                }
                comp.show();
            }
            if (metadata instanceof DummyMetadata) {
                comp.hide();
            }
        }
    }
}

