/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.filter;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FilenameUtils;

public class FilterFileChooser
extends JFileChooser {
    private static final String FILTER_EXT = "filter";
    private static final long serialVersionUID = -3733290468455212962L;
    private FileNameExtensionFilter filterFilter;

    public FilterFileChooser(File startingDir) {
        super(startingDir);
    }

    @Override
    protected void setup(FileSystemView view) {
        super.setup(view);
        this.setAcceptAllFileFilterUsed(true);
        this.filterFilter = new FileNameExtensionFilter("Droid filter files (*.filter)", FILTER_EXT);
        this.addChoosableFileFilter(this.filterFilter);
    }

    @Override
    public void approveSelection() {
        String filename;
        String ext;
        int confirm = 0;
        if (!this.getSelectedFile().exists() && this.getFileFilter().equals(this.filterFilter) && !FILTER_EXT.equals(ext = FilenameUtils.getExtension((String)(filename = this.getSelectedFile().getName())))) {
            this.setSelectedFile(new File(this.getSelectedFile().getParentFile(), filename + "." + FILTER_EXT));
        }
        if (this.getDialogType() == 1 && this.getSelectedFile().exists()) {
            confirm = JOptionPane.showConfirmDialog(this, "The file you have selected already exists. Do you wish to overwrite it?", "File exists warning", 1, 2);
        }
        if (confirm == 0) {
            super.approveSelection();
        } else if (confirm == 2) {
            super.cancelSelection();
        }
    }
}

