/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.filter.domain;

import java.util.LinkedHashSet;
import java.util.List;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionFieldEnum;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionOperator;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterValue;
import uk.gov.nationalarchives.droid.gui.filter.domain.GenericMetadata;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;

public class FileFormatMetadata
extends GenericMetadata {
    private static final String DISPLAY_NAME = "File format";

    public FileFormatMetadata(List<Format> data) {
        super(CriterionFieldEnum.FILE_FORMAT);
        this.addOperation(CriterionOperator.EQ);
        this.addOperation(CriterionOperator.STARTS_WITH);
        this.addOperation(CriterionOperator.NE);
        this.addOperation(CriterionOperator.ENDS_WITH);
        this.addOperation(CriterionOperator.CONTAINS);
        this.addOperation(CriterionOperator.NOT_STARTS_WITH);
        this.addOperation(CriterionOperator.NOT_ENDS_WITH);
        this.addOperation(CriterionOperator.NOT_CONTAINS);
        LinkedHashSet<String> uniqueFormat = new LinkedHashSet<String>();
        int index = 0;
        for (Format formatFromDatabase : data) {
            uniqueFormat.add(formatFromDatabase.getName());
        }
        index = 0;
        for (String format : uniqueFormat) {
            this.addPossibleValue(new FilterValue(index++, format, format));
        }
    }

    @Override
    public boolean isFreeText() {
        return true;
    }
}

