/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.filter.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionFieldEnum;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionOperator;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterValue;
import uk.gov.nationalarchives.droid.gui.filter.domain.FilterValidationException;
import uk.gov.nationalarchives.droid.gui.filter.domain.Metadata;

public class GenericMetadata
implements Metadata {
    public static final String EQUALS = "=";
    public static final String NOT_EQUALS = "<>";
    public static final String LIKE = "Begins with";
    public static final String LESS_THAN = "<";
    public static final String GREATER_THAN = ">";
    public static final String LESS_THAN_OR_EQUALS = "<=";
    public static final String GREATER_THAN_OR_EQUALS = ">=";
    public static final String ANY_OF = "Any of";
    public static final String NONE_OF = "None of";
    public static final String CONTAINS = "Cointains";
    public static final String ENDS_WITH = "Ends with";
    public static final String OP_EQUALS = "=";
    public static final String OP_NOT_EQUALS = "!=";
    public static final String OP_LIKE = "like";
    public static final String OP_LESS_THAN = "<";
    public static final String OP_GREATER_THAN = ">";
    public static final String OP_LESS_THAN_OR_EQUALS = "<=";
    public static final String OP_GREATER_THAN_OR_EQUALS = ">=";
    public static final String OP_ANY_OF = "=";
    public static final String OP_NONE_OF = "!=";
    public static final String OP_CONTAINS = "%like%";
    public static final String OP_ENDS_WITH = "like%";
    private Map<String, String> operationMap = new HashMap<String, String>();
    private CriterionFieldEnum metadataName;
    private final List<CriterionOperator> operationList = new ArrayList<CriterionOperator>();
    private List<FilterValue> possibleValues = new ArrayList<FilterValue>();

    public GenericMetadata(CriterionFieldEnum metadataName) {
        this.metadataName = metadataName;
        this.operationMap.put("=", "=");
        this.operationMap.put(NOT_EQUALS, "!=");
        this.operationMap.put(LIKE, OP_LIKE);
        this.operationMap.put("<", "<");
        this.operationMap.put(">", ">");
        this.operationMap.put("<=", "<=");
        this.operationMap.put(">=", ">=");
        this.operationMap.put(ANY_OF, "=");
        this.operationMap.put(NONE_OF, "!=");
        this.operationMap.put(CONTAINS, OP_CONTAINS);
        this.operationMap.put(ENDS_WITH, OP_ENDS_WITH);
    }

    public Map<String, String> getOperationMap() {
        return this.operationMap;
    }

    public void setOperationMap(Map<String, String> operationMap) {
        this.operationMap = operationMap;
    }

    @Override
    public CriterionFieldEnum getMetadataName() {
        return this.metadataName;
    }

    @Override
    public final List<CriterionOperator> getOperationList() {
        return this.operationList;
    }

    @Override
    public final List<FilterValue> getPossibleValues() {
        return this.possibleValues;
    }

    void addPossibleValue(FilterValue value) {
        this.possibleValues.add(value);
    }

    void addOperation(CriterionOperator operation) {
        this.operationList.add(operation);
    }

    @Override
    public boolean isFreeText() {
        return true;
    }

    @Override
    public void validate(String stringToValidate) throws FilterValidationException {
    }

    public String toString() {
        return this.getMetadataName().toString();
    }

    public CriterionFieldEnum getField() {
        return this.metadataName;
    }
}

