/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.filter.domain;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionFieldEnum;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionOperator;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterValue;
import uk.gov.nationalarchives.droid.gui.filter.domain.GenericMetadata;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;

public class MimeTypeMetadata
extends GenericMetadata {
    private static final String DISPLAY_NAME = "Mime type";

    public MimeTypeMetadata(List<Format> data) {
        super(CriterionFieldEnum.MIME_TYPE);
        this.addOperation(CriterionOperator.ANY_OF);
        this.addOperation(CriterionOperator.NONE_OF);
        int index = 0;
        for (Format format : data) {
            if (!StringUtils.isNotBlank((String)format.getMimeType()) || this.isExists(this.getPossibleValues(), format.getMimeType())) continue;
            this.addPossibleValue(new FilterValue(index++, format.getMimeType(), format.getMimeType()));
        }
    }

    private boolean isExists(List<FilterValue> values, String mimeType) {
        for (FilterValue value : values) {
            if (!value.getDescription().equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFreeText() {
        return false;
    }
}

