/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.filter.domain;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionFieldEnum;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionOperator;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterValue;
import uk.gov.nationalarchives.droid.gui.filter.domain.FilterValidationException;
import uk.gov.nationalarchives.droid.gui.filter.domain.GenericMetadata;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;

public class PUIDMetadata
extends GenericMetadata {
    private static final String DISPLAY_NAME = "PUID";
    private static final FilterValueComparator PUID_SORT = new FilterValueComparator();

    public PUIDMetadata(List<Format> data) {
        super(CriterionFieldEnum.PUID);
        this.addOperation(CriterionOperator.ANY_OF);
        this.addOperation(CriterionOperator.NONE_OF);
        int index = 0;
        ArrayList<FilterValue> possibleFilterValues = new ArrayList<FilterValue>();
        for (Format format : data) {
            String formatWithVersion = "";
            formatWithVersion = format.getVersion() != null ? " ( " + format.getName() + " - " + format.getVersion() + " )" : " (" + format.getName() + ")";
            if (format.getPuid() == null) continue;
            possibleFilterValues.add(new FilterValue(index++, format.getPuid() + formatWithVersion, format.getPuid()));
        }
        possibleFilterValues.sort(PUID_SORT);
        for (FilterValue value : possibleFilterValues) {
            this.addPossibleValue(value);
        }
    }

    @Override
    public boolean isFreeText() {
        return false;
    }

    @Override
    public void validate(String stringTovalidate) throws FilterValidationException {
        if (StringUtils.isBlank((String)stringTovalidate)) {
            throw new FilterValidationException("PUID can not be blank");
        }
    }

    private static class FilterValueComparator
    implements Comparator<FilterValue> {
        private FilterValueComparator() {
        }

        @Override
        public int compare(FilterValue o1, FilterValue o2) {
            String puid1 = o1.getQueryParameter();
            String puid2 = o2.getQueryParameter();
            int separator1Pos = puid1.indexOf(47);
            int separator2Pos = puid2.indexOf(47);
            int result = -1;
            if (separator1Pos >= 0 && separator2Pos >= 0) {
                if (separator1Pos != separator2Pos) {
                    result = separator1Pos - separator2Pos;
                } else {
                    String puid2header;
                    String puid1header = puid1.substring(0, separator1Pos);
                    if (!puid1header.equals(puid2header = puid2.substring(0, separator2Pos))) {
                        result = puid1.compareTo(puid2);
                    } else {
                        String puid1ID = puid1.substring(separator1Pos + 1);
                        String puid2ID = puid2.substring(separator2Pos + 1);
                        int puid1Num = this.getInteger(puid1ID);
                        int puid2Num = this.getInteger(puid2ID);
                        if (puid1Num >= 0 && puid2Num >= 0) {
                            result = puid1Num - puid2Num;
                        }
                    }
                }
            } else {
                result = puid1.compareTo(puid2);
            }
            return result;
        }

        private int getInteger(String string) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
    }
}

