/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.help;

import java.awt.Desktop;
import java.awt.Frame;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.help.JHelpContentViewer;
import javax.help.plaf.basic.BasicContentViewerUI;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.ComponentUI;
import uk.gov.nationalarchives.droid.gui.DialogUtils;

public class ExternalLinkContentViewerUI
extends BasicContentViewerUI {
    public ExternalLinkContentViewerUI(JHelpContentViewer context) {
        super(context);
    }

    public static ComponentUI createUI(JComponent x) {
        return new ExternalLinkContentViewerUI((JHelpContentViewer)x);
    }

    public void hyperlinkUpdate(HyperlinkEvent he) {
        if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL u = he.getURL();
            if ("mailto".equalsIgnoreCase(u.getProtocol()) || "http".equalsIgnoreCase(u.getProtocol()) || "ftp".equalsIgnoreCase(u.getProtocol())) {
                Desktop desktop = null;
                if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                    try {
                        desktop.browse(u.toURI());
                    }
                    catch (MalformedURLException e1) {
                        DialogUtils.showGeneralErrorDialog(new Frame(), "MalformedURLException", "Invalid URL.");
                    }
                    catch (IOException e1) {
                        DialogUtils.showGeneralErrorDialog(new Frame(), "IOException", "Resource not found.");
                    }
                    catch (URISyntaxException uriSyntaxEx) {
                        DialogUtils.showGeneralErrorDialog(new Frame(), "URISyntaxException", "Invalid URI.");
                    }
                }
            } else {
                super.hyperlinkUpdate(he);
            }
        }
    }
}

